/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.api.jms;

import com.mulesoft.mule.runtime.bti.api.jms.AbstractConnectionFactoryDecorator;
import com.mulesoft.mule.runtime.bti.api.jms.BitronixConnectionFactoryWrapper;
import com.mulesoft.mule.runtime.bti.api.jms.JmsConnectionConfig;
import com.mulesoft.mule.runtime.bti.api.transaction.MuleTransactionManager;
import javax.jms.ConnectionFactory;
import javax.jms.XAConnectionFactory;
import org.mule.runtime.core.api.MuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BitronixConnectionFactoryDecorator
extends AbstractConnectionFactoryDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BitronixConnectionFactoryDecorator.class);

    @Override
    protected ConnectionFactory doDecorate(ConnectionFactory connectionFactory, JmsConnectionConfig jmsConfig, MuleContext muleContext) {
        if (!this.isConnectionFactoryWrapper(connectionFactory) && this.isXaConnectionFactory(connectionFactory)) {
            LOGGER.info(String.format("No pool defined for XAConnectionFactory in connector %s. A default pool will be created. To customize define a bti:xa-caching-connection-factory element in your config and assign it to the connector.", jmsConfig.getName()));
            BitronixConnectionFactoryWrapper connectionFactoryWrapper = new BitronixConnectionFactoryWrapper();
            connectionFactoryWrapper.setMuleContext(muleContext);
            connectionFactoryWrapper.setConnectionFactory((XAConnectionFactory)connectionFactory);
            connectionFactoryWrapper.setName(jmsConfig.getName());
            connectionFactoryWrapper.setUsername(jmsConfig.getUsername());
            connectionFactoryWrapper.setPassword(jmsConfig.getPassword());
            connectionFactoryWrapper.setMaxIdleTime(jmsConfig.getMaxIdleTime());
            connectionFactoryWrapper.setMinPoolSize(jmsConfig.getMinPoolSize());
            connectionFactoryWrapper.setMaxPoolSize(jmsConfig.getMaxPoolSize());
            return connectionFactoryWrapper;
        }
        if (this.isConnectionFactoryWrapper(connectionFactory)) {
            BitronixConnectionFactoryWrapper connectionFactoryWrapper = (BitronixConnectionFactoryWrapper)connectionFactory;
            connectionFactoryWrapper.setUsername(jmsConfig.getUsername());
            connectionFactoryWrapper.setPassword(jmsConfig.getPassword());
        }
        return connectionFactory;
    }

    @Override
    public boolean appliesTo(ConnectionFactory connectionFactory, MuleContext muleContext) {
        return this.isBitronixTxManager(muleContext) && (this.isConnectionFactoryWrapper(connectionFactory) || this.isXaConnectionFactory(connectionFactory));
    }

    private boolean isBitronixTxManager(MuleContext muleContext) {
        return muleContext.getTransactionManager() instanceof MuleTransactionManager;
    }
}

