/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.raml;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonExampleTypeLoader;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.module.apikit.metadata.internal.raml.RamlApiWrapper;
import org.mule.module.apikit.metadata.internal.utils.CommonMetadataFactory;
import org.mule.runtime.api.metadata.MediaType;

class MetadataFactory {
    private static final MetadataType STRING_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();

    private MetadataFactory() {
    }

    public static MetadataType payloadMetadata(RamlApiWrapper api, @Nullable MimeType body) {
        if (body == null) {
            return CommonMetadataFactory.defaultMetadata();
        }
        MediaType mType = MediaType.parse((String)body.getType());
        String type = mType.getPrimaryType() + "/" + mType.getSubType();
        String schema = MetadataFactory.resolveSchema(api, body);
        String example = body.getExample();
        switch (type) {
            case "application/json": {
                return MetadataFactory.applicationJsonMetadata(schema, example);
            }
            case "application/xml": {
                return MetadataFactory.applicationXmlMetadata(schema, example);
            }
            case "application/x-www-form-urlencoded": 
            case "multipart/form-data": {
                return MetadataFactory.formMetadata(body.getFormParameters());
            }
        }
        return CommonMetadataFactory.defaultMetadata();
    }

    private static String resolveSchema(RamlApiWrapper api, MimeType body) {
        String schema = body.getSchema();
        if (api.getConsolidatedSchemas().containsKey(schema)) {
            schema = api.getConsolidatedSchemas().get(schema);
        }
        return schema;
    }

    private static MetadataType formMetadata(Map<String, List<Parameter>> formParameters) {
        return MetadataFactory.fromFormMetadata(formParameters);
    }

    private static MetadataType applicationXmlMetadata(String schema, String example) {
        MetadataType fromExample;
        if (schema != null && schema.contains("XMLSchema")) {
            return CommonMetadataFactory.fromXSDSchema(schema);
        }
        if (example != null && !example.isEmpty() && (fromExample = CommonMetadataFactory.fromXMLExample(example)) != null) {
            return fromExample;
        }
        return CommonMetadataFactory.defaultMetadata();
    }

    private static MetadataType applicationJsonMetadata(String schema, String example) {
        if (schema != null) {
            return MetadataFactory.fromJsonSchema(schema);
        }
        if (example != null) {
            return MetadataFactory.fromJsonExample(example);
        }
        return CommonMetadataFactory.defaultMetadata();
    }

    public static MetadataType fromJsonSchema(String jsonSchema) {
        JsonTypeLoader jsonTypeLoader = new JsonTypeLoader(jsonSchema);
        Optional root = jsonTypeLoader.load(null);
        return root.orElse(CommonMetadataFactory.defaultMetadata());
    }

    private static MetadataType fromJsonExample(String jsonExample) {
        JsonExampleTypeLoader jsonExampleTypeLoader = new JsonExampleTypeLoader(jsonExample);
        jsonExampleTypeLoader.setFieldRequirementDefault(false);
        Optional root = jsonExampleTypeLoader.load(null);
        return root.orElse(CommonMetadataFactory.defaultMetadata());
    }

    public static MetadataType fromFormMetadata(Map<String, List<Parameter>> formParameters) {
        ObjectTypeBuilder parameters = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        for (Map.Entry<String, List<Parameter>> entry : formParameters.entrySet()) {
            parameters.addField().key(entry.getKey()).value().anyType();
        }
        return parameters.build();
    }

    public static MetadataType stringMetadata() {
        return STRING_METADATA;
    }

    public static MetadataType objectMetadata() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().build();
    }

    public static MetadataType binaryMetadata() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).binaryType().build();
    }
}

