/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptyListSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptyMapSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptySetSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonListSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonMapSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonSetSerializer;
import de.javakaffee.kryoserializers.GregorianCalendarSerializer;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import de.javakaffee.kryoserializers.cglib.CGLibProxySerializer;
import de.javakaffee.kryoserializers.guava.ArrayListMultimapSerializer;
import de.javakaffee.kryoserializers.guava.HashMultimapSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableListSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableMapSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableMultimapSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableSetSerializer;
import de.javakaffee.kryoserializers.guava.LinkedHashMultimapSerializer;
import de.javakaffee.kryoserializers.guava.LinkedListMultimapSerializer;
import de.javakaffee.kryoserializers.guava.ReverseListSerializer;
import de.javakaffee.kryoserializers.guava.TreeMultimapSerializer;
import de.javakaffee.kryoserializers.guava.UnmodifiableNavigableSetSerializer;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.tooling.client.internal.serialization.ClassLoaderClassSerializerFilter;
import org.mule.tooling.client.internal.serialization.ClassLoaderFieldSerializerFilter;
import org.mule.tooling.client.internal.serialization.CompatibleClassResolver;
import org.mule.tooling.client.internal.serialization.DefaultArrayTypeSerializer;
import org.mule.tooling.client.internal.serialization.DefaultInstantiatorStrategyWithCache;
import org.mule.tooling.client.internal.serialization.ExtendedCompatibleFieldSerializer;
import org.mule.tooling.client.internal.serialization.ExternalizableKryo;
import org.mule.tooling.client.internal.serialization.InputStreamKryoSerializer;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public final class KryoFactory {
    private KryoFactory() {
    }

    public static Kryo defaultKryo() {
        Kryo kryo = new Kryo();
        kryo.setDefaultSerializer(CompatibleFieldSerializer.class);
        KryoFactory.configure(kryo, null);
        return kryo;
    }

    public static Kryo externalizableKryo() {
        ExternalizableKryo kryo = new ExternalizableKryo((ClassResolver)new CompatibleClassResolver());
        kryo.setDefaultSerializer(CompatibleFieldSerializer.class);
        KryoFactory.configure(kryo, null);
        return kryo;
    }

    public static Kryo externalizableKryo(ClassLoader targetClassLoader) {
        ClassLoaderClassSerializerFilter classLoaderClassFieldSerializerFilter = new ClassLoaderClassSerializerFilter(targetClassLoader);
        ClassLoaderFieldSerializerFilter classLoaderFieldSerializerFilter = new ClassLoaderFieldSerializerFilter(targetClassLoader);
        ExternalizableKryo kryo = new ExternalizableKryo(classLoaderClassFieldSerializerFilter, classLoaderFieldSerializerFilter, (ClassResolver)new CompatibleClassResolver());
        kryo.setDefaultSerializer(ExtendedCompatibleFieldSerializer.class);
        KryoFactory.configure(kryo, targetClassLoader);
        return kryo;
    }

    private static void configure(Kryo kryo, ClassLoader targetClassLoader) {
        kryo.addDefaultSerializer(DefaultArrayType.class, new DefaultArrayTypeSerializer());
        kryo.getFieldSerializerConfig().setCachedFieldNameStrategy(FieldSerializer.CachedFieldNameStrategy.EXTENDED);
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new DefaultInstantiatorStrategyWithCache((InstantiatorStrategy)new StdInstantiatorStrategy()));
        kryo.register(Arrays.asList("").getClass(), (Serializer)new ArraysAsListSerializer());
        kryo.register(Collections.EMPTY_LIST.getClass(), (Serializer)new CollectionsEmptyListSerializer());
        kryo.register(Collections.EMPTY_MAP.getClass(), (Serializer)new CollectionsEmptyMapSerializer());
        kryo.register(Collections.EMPTY_SET.getClass(), (Serializer)new CollectionsEmptySetSerializer());
        kryo.register(Collections.singletonList("").getClass(), (Serializer)new CollectionsSingletonListSerializer());
        kryo.register(Collections.singleton("").getClass(), (Serializer)new CollectionsSingletonSetSerializer());
        kryo.register(Collections.singletonMap("", "").getClass(), (Serializer)new CollectionsSingletonMapSerializer());
        kryo.register(GregorianCalendar.class, (Serializer)new GregorianCalendarSerializer());
        kryo.register(InvocationHandler.class, (Serializer)new JdkProxySerializer());
        UnmodifiableCollectionsSerializer.registerSerializers((Kryo)kryo);
        SynchronizedCollectionsSerializer.registerSerializers((Kryo)kryo);
        kryo.register(CGLibProxySerializer.CGLibProxyMarker.class, (Serializer)new CGLibProxySerializer());
        ImmutableListSerializer.registerSerializers((Kryo)kryo);
        ImmutableSetSerializer.registerSerializers((Kryo)kryo);
        ImmutableMapSerializer.registerSerializers((Kryo)kryo);
        ImmutableMultimapSerializer.registerSerializers((Kryo)kryo);
        ReverseListSerializer.registerSerializers((Kryo)kryo);
        UnmodifiableNavigableSetSerializer.registerSerializers((Kryo)kryo);
        ArrayListMultimapSerializer.registerSerializers((Kryo)kryo);
        HashMultimapSerializer.registerSerializers((Kryo)kryo);
        LinkedHashMultimapSerializer.registerSerializers((Kryo)kryo);
        LinkedListMultimapSerializer.registerSerializers((Kryo)kryo);
        TreeMultimapSerializer.registerSerializers((Kryo)kryo);
        if (KryoFactory.isClassAvailable(targetClassLoader, InputStreamKryoSerializer.class.getName())) {
            kryo.register(InputStream.class, (Serializer)new InputStreamKryoSerializer());
        }
        kryo.register(File.class, new Serializer(){

            public void write(Kryo kryo, Output output, Object object) {
                output.writeString(((File)object).getAbsolutePath());
            }

            public Object read(Kryo kryo, Input input, Class type) {
                return new File(input.readString());
            }
        });
    }

    private static boolean isClassAvailable(ClassLoader classLoader, String name) {
        if (classLoader == null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(name, false, classLoader);
            return null != clazz;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

