/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.framework.api.tooling.type.propagation.TypePropagationRequest;
import org.mule.framework.api.tooling.type.propagation.TypePropagationResult;
import org.mule.framework.api.tooling.type.propagation.TypedChainComponent;
import org.mule.framework.api.tooling.type.propagation.TypedEventField;
import org.mule.framework.internal.tooling.type.propagation.DefaultTypePropagationResult;
import org.mule.framework.internal.tooling.type.propagation.DefaultTypedChainComponent;
import org.mule.framework.internal.tooling.type.propagation.TypedEventFieldBuilder;
import org.mule.framework.internal.tooling.type.propagation.cfg.TypePropagationCFGVisitor;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.AstTraversalDirection;

public class TypePropagationResolverUtils {
    private TypePropagationResolverUtils() {
    }

    public static TypePropagationResult resolve(ComponentAst ast, TypePropagationRequest request, TypePropagationCFGVisitor visitor, Map<ComponentLocation, ConnectableComponentModel> updatedModels) {
        if (!visitor.wasSuccessfulPropagation()) {
            return DefaultTypePropagationResult.failure(TypePropagationResolverUtils.retrieveErrors(ast, visitor, request));
        }
        HashMap<String, TypedEventFieldBuilder> calculated = new HashMap<String, TypedEventFieldBuilder>();
        HashMap<ComponentLocation, TypedChainComponent> result = new HashMap<ComponentLocation, TypedChainComponent>();
        ast.recursiveStream(AstTraversalDirection.BOTTOM_UP).filter(componentAst -> TypePropagationResolverUtils.isComponentWithPropagationResult(componentAst, request)).forEach(componentAst -> result.put(componentAst.getLocation(), new DefaultTypedChainComponent(componentAst.getLocation(), TypePropagationResolverUtils.getMetadataDescriptor(componentAst, visitor, Optional.ofNullable(updatedModels.getOrDefault(componentAst.getLocation(), null))), TypePropagationResolverUtils.getInputPayloadField(componentAst, request, visitor, calculated), TypePropagationResolverUtils.getPayloadField(componentAst, request, visitor, calculated), TypePropagationResolverUtils.getInputAttributesField(componentAst, request, visitor, calculated), TypePropagationResolverUtils.getAttributesField(componentAst, request, visitor, calculated), TypePropagationResolverUtils.getVariables(componentAst, request, visitor.getInputVariables(componentAst.getLocation()), calculated))));
        TypedEventField flowsOutput = TypePropagationResolverUtils.buildTypedEventField(calculated, ast.getLocation().getRootContainerName(), visitor.getLastMetadataType(), ast.getLocation(), request.traceMetadataDefinitionLocation());
        TypedEventField flowsOutputAttr = TypePropagationResolverUtils.buildTypedEventField(calculated, ast.getLocation().getRootContainerName(), visitor.getLastAttributesType(), ast.getLocation(), request.traceMetadataDefinitionLocation());
        result.put(ast.getLocation(), new DefaultTypedChainComponent(ast.getLocation(), Optional.empty(), Optional.empty(), flowsOutput, Optional.empty(), flowsOutputAttr, TypePropagationResolverUtils.getVariables(ast, request, visitor.getLastVariables(), calculated)));
        return DefaultTypePropagationResult.success(result);
    }

    private static List<I18nMessage> retrieveErrors(ComponentAst ast, TypePropagationCFGVisitor visitor, TypePropagationRequest request) {
        return ast.recursiveStream().filter(componentAst -> TypePropagationResolverUtils.isComponentWithPropagationResult(componentAst, request)).filter(componentAst -> !visitor.getResult(componentAst.getLocation()).isSuccess()).flatMap(componentAst -> visitor.getResult(componentAst.getLocation()).getFailures().stream()).map(metadataFailure -> I18nMessageFactory.createStaticMessage((String)metadataFailure.getMessage())).collect(Collectors.toList());
    }

    private static boolean isComponentWithPropagationResult(ComponentAst ast, TypePropagationRequest request) {
        return ast.getModel(OperationModel.class).isPresent() || ast.getModel(SourceModel.class).isPresent() && !request.getInitialMetadataTypeOverride().isPresent();
    }

    private static TypedEventField buildTypedEventField(Map<String, TypedEventFieldBuilder> calculated, String name, MetadataType type, ComponentLocation location, boolean traceDeclaration) {
        TypedEventFieldBuilder builder;
        if (calculated.containsKey(name) && calculated.get(name).isType(type)) {
            builder = calculated.get(name);
        } else {
            builder = new TypedEventFieldBuilder();
            if (traceDeclaration) {
                builder.withDeclarationIn(location);
            }
            builder.withMetadataType(type);
            calculated.put(name, builder);
        }
        return builder.build();
    }

    private static Optional<TypedEventField> getInputPayloadField(ComponentAst ast, TypePropagationRequest request, TypePropagationCFGVisitor visitor, Map<String, TypedEventFieldBuilder> calculated) {
        String containerName = ast.getLocation().getRootContainerName();
        return visitor.getInput(ast.getLocation()).flatMap(MessageMetadataType::getPayloadType).map(inputMetadata -> TypePropagationResolverUtils.buildTypedEventField(calculated, containerName + "-payload", inputMetadata, ast.getLocation(), false));
    }

    private static Optional<TypedEventField> getInputAttributesField(ComponentAst ast, TypePropagationRequest request, TypePropagationCFGVisitor visitor, Map<String, TypedEventFieldBuilder> calculated) {
        String containerName = ast.getLocation().getRootContainerName();
        return visitor.getInput(ast.getLocation()).flatMap(MessageMetadataType::getAttributesType).map(inputMetadata -> TypePropagationResolverUtils.buildTypedEventField(calculated, containerName + "-attributes", inputMetadata, ast.getLocation(), false));
    }

    private static TypedEventField getPayloadField(ComponentAst ast, TypePropagationRequest request, TypePropagationCFGVisitor visitor, Map<String, TypedEventFieldBuilder> calculated) {
        MetadataResult<HasOutputModel> result = visitor.getResult(ast.getLocation());
        MetadataType outputMetadata = ((HasOutputModel)result.get()).getOutput().getType();
        String containerName = ast.getLocation().getRootContainerName();
        return TypePropagationResolverUtils.buildTypedEventField(calculated, containerName + "-payload", outputMetadata, ast.getLocation(), request.traceMetadataDefinitionLocation());
    }

    private static TypedEventField getAttributesField(ComponentAst ast, TypePropagationRequest request, TypePropagationCFGVisitor visitor, Map<String, TypedEventFieldBuilder> calculated) {
        MetadataResult<HasOutputModel> result = visitor.getResult(ast.getLocation());
        MetadataType attrMetadata = ((HasOutputModel)result.get()).getOutputAttributes().getType();
        if (attrMetadata == null) {
            return null;
        }
        String containerName = ast.getLocation().getRootContainerName();
        return TypePropagationResolverUtils.buildTypedEventField(calculated, containerName + "-attributes", attrMetadata, ast.getLocation(), request.traceMetadataDefinitionLocation());
    }

    private static Map<String, TypedEventField> getVariables(ComponentAst ast, TypePropagationRequest request, Map<String, MetadataType> varsMetadata, Map<String, TypedEventFieldBuilder> calculated) {
        HashMap<String, TypedEventField> vars = new HashMap<String, TypedEventField>();
        varsMetadata.forEach((name, type) -> vars.put((String)name, TypePropagationResolverUtils.buildTypedEventField(calculated, name, type, ast.getLocation(), request.traceMetadataDefinitionLocation())));
        return vars;
    }

    private static Optional<ComponentMetadataTypesDescriptor> getMetadataDescriptor(ComponentAst ast, TypePropagationCFGVisitor visitor, Optional<ConnectableComponentModel> updatedModel) {
        Reference dynamic = new Reference((Object)false);
        MetadataResult<HasOutputModel> result = visitor.getResult(ast.getLocation());
        if (result == null || !result.isSuccess()) {
            return Optional.empty();
        }
        MetadataType output = ((HasOutputModel)result.get()).getOutput().getType();
        ComponentMetadataTypesDescriptor.ComponentMetadataTypesDescriptorBuilder builder = ComponentMetadataTypesDescriptor.builder();
        InputMetadataDescriptor.InputMetadataDescriptorBuilder inputBuilder = InputMetadataDescriptor.builder();
        OutputMetadataDescriptor.OutputMetadataDescriptorBuilder outputBuilder = OutputMetadataDescriptor.builder();
        ast.getModel(HasOutputModel.class).ifPresent(outputModel -> {
            if (outputModel.getOutput().hasDynamicType() && output != null) {
                dynamic.set((Object)true);
                outputBuilder.withReturnType(TypeMetadataDescriptor.builder().withType(output).dynamic(outputModel.getOutput().hasDynamicType()).build());
            } else {
                outputBuilder.withReturnType(TypeMetadataDescriptor.builder().withType(outputModel.getOutput().getType()).dynamic(outputModel.getOutput().hasDynamicType()).build());
            }
            if (outputModel.getOutputAttributes().hasDynamicType() && updatedModel.isPresent()) {
                dynamic.set((Object)true);
                outputBuilder.withAttributesType(((ConnectableComponentModel)updatedModel.get()).getOutputAttributes().getType());
            } else {
                outputBuilder.withAttributesType(TypePropagationResolverUtils.typeDescriptorFromOutput(outputModel));
            }
        });
        updatedModel.ifPresent(model -> model.getAllParameterModels().forEach(pm -> {
            TypePropagationResolverUtils.generateParameterDescriptor(pm, inputBuilder);
            if (pm.hasDynamicType()) {
                dynamic.set((Object)true);
            }
        }));
        return (Boolean)dynamic.get() != false ? Optional.of(builder.withOutputMetadataDescriptor(outputBuilder.build()).withInputMetadataDescriptor(inputBuilder.build()).build()) : Optional.empty();
    }

    private static TypeMetadataDescriptor typeDescriptorFromOutput(HasOutputModel outputModel) {
        return TypeMetadataDescriptor.builder().withType(outputModel.getOutputAttributes().getType()).dynamic(outputModel.getOutputAttributes().hasDynamicType()).build();
    }

    private static void generateParameterDescriptor(ParameterModel pm, InputMetadataDescriptor.InputMetadataDescriptorBuilder inputBuilder) {
        inputBuilder.withParameter(pm.getName(), ParameterMetadataDescriptor.builder((String)pm.getName()).withType(pm.getType()).dynamic(pm.hasDynamicType()).build());
    }
}

