/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;

public class ModelsUtils {
    private ModelsUtils() {
    }

    public static OperationModel getTypedOperationModel(OperationModel operationModel, Map<String, MetadataType> inputMetadata, Optional<MetadataType> outputMetadata, Optional<MetadataType> attributesMetadata) {
        OutputModel typedOutputModel = ModelsUtils.resolveOutputModelType(operationModel.getOutput(), outputMetadata);
        OutputModel typedAttributesModel = ModelsUtils.resolveOutputModelType(operationModel.getOutputAttributes(), attributesMetadata);
        return new ImmutableOperationModel(operationModel.getName(), operationModel.getDescription(), ModelsUtils.resolveParameterGroupModelType(operationModel.getParameterGroupModels(), inputMetadata), operationModel.getNestedComponents(), typedOutputModel, typedAttributesModel, operationModel.isBlocking(), operationModel.getExecutionType(), operationModel.requiresConnection(), operationModel.isTransactional(), operationModel.supportsStreaming(), (DisplayModel)operationModel.getDisplayModel().orElse(null), operationModel.getErrorModels(), operationModel.getStereotype(), operationModel.getVisibility(), operationModel.getModelProperties(), operationModel.getNotificationModels(), (DeprecationModel)operationModel.getDeprecationModel().orElse(null));
    }

    public static SourceModel getTypedSourceModel(SourceModel sourceModel, Map<String, MetadataType> inputMetadata, Optional<MetadataType> outputMetadata, Optional<MetadataType> attributesMetadata) {
        OutputModel typedOutputModel = ModelsUtils.resolveOutputModelType(sourceModel.getOutput(), outputMetadata);
        OutputModel typedAttributesModel = ModelsUtils.resolveOutputModelType(sourceModel.getOutputAttributes(), attributesMetadata);
        return new ImmutableSourceModel(sourceModel.getName(), sourceModel.getDescription(), sourceModel.hasResponse(), sourceModel.runsOnPrimaryNodeOnly(), ModelsUtils.resolveParameterGroupModelType(sourceModel.getParameterGroupModels(), inputMetadata), ModelsUtils.resolveNestableElementModels(), typedOutputModel, typedAttributesModel, sourceModel.getSuccessCallback(), sourceModel.getErrorCallback(), sourceModel.getTerminateCallback(), sourceModel.requiresConnection(), sourceModel.isTransactional(), sourceModel.supportsStreaming(), (DisplayModel)sourceModel.getDisplayModel().orElse(null), sourceModel.getStereotype(), sourceModel.getErrorModels(), sourceModel.getVisibility(), sourceModel.getModelProperties(), sourceModel.getNotificationModels(), (DeprecationModel)sourceModel.getDeprecationModel().orElse(null));
    }

    private static OutputModel resolveOutputModelType(OutputModel untypedModel, Optional<MetadataType> metadataType) {
        return new ImmutableOutputModel(untypedModel.getDescription(), (MetadataType)metadataType.orElse(null), untypedModel.hasDynamicType(), untypedModel.getModelProperties());
    }

    private static List<ParameterGroupModel> resolveParameterGroupModelType(List<ParameterGroupModel> untypedParameterGroups, Map<String, MetadataType> inputMetadata) {
        LinkedList<ParameterGroupModel> parameterGroups = new LinkedList<ParameterGroupModel>();
        untypedParameterGroups.forEach(parameterGroup -> {
            LinkedList parameters = new LinkedList();
            parameterGroup.getParameterModels().forEach(parameterModel -> {
                MetadataType parameterType = inputMetadata.get(parameterModel.getName()) != null ? (MetadataType)inputMetadata.get(parameterModel.getName()) : parameterModel.getType();
                ImmutableParameterModel typedParameterModel = new ImmutableParameterModel(parameterModel.getName(), parameterModel.getDescription(), parameterType, parameterModel.hasDynamicType(), parameterModel.isRequired(), parameterModel.isOverrideFromConfig(), parameterModel.isComponentId(), parameterModel.getExpressionSupport(), parameterModel.getDefaultValue(), parameterModel.getRole(), parameterModel.getDslConfiguration(), (DisplayModel)parameterModel.getDisplayModel().orElse(null), (LayoutModel)parameterModel.getLayoutModel().orElse(null), (ValueProviderModel)parameterModel.getValueProviderModel().orElse(null), parameterModel.getAllowedStereotypes(), parameterModel.getModelProperties(), (DeprecationModel)parameterModel.getDeprecationModel().orElse(null));
                parameters.add(typedParameterModel);
            });
            parameterGroups.add((ParameterGroupModel)new ImmutableParameterGroupModel(parameterGroup.getName(), parameterGroup.getDescription(), parameters, parameterGroup.getExclusiveParametersModels(), parameterGroup.isShowInDsl(), (DisplayModel)parameterGroup.getDisplayModel().orElse(null), (LayoutModel)parameterGroup.getLayoutModel().orElse(null), parameterGroup.getModelProperties()));
        });
        return parameterGroups;
    }

    private static List<? extends NestableElementModel> resolveNestableElementModels() {
        return Collections.emptyList();
    }
}

