/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.cfg;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.mule.framework.api.tooling.type.propagation.BaseTypePropagationRequest;
import org.mule.framework.api.tooling.type.propagation.TypePropagationRequest;
import org.mule.framework.api.tooling.type.propagation.TypePropagationResult;
import org.mule.framework.api.tooling.type.propagation.TypePropagationSession;
import org.mule.framework.api.tooling.type.propagation.TypedEventField;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.tooling.type.propagation.DefaultTypePropagationResult;
import org.mule.framework.internal.tooling.type.propagation.cfg.TypePropagationCFGVisitor;
import org.mule.framework.internal.tooling.type.propagation.utils.ApiKitUtils;
import org.mule.framework.internal.tooling.type.propagation.utils.CoreUtils;
import org.mule.framework.internal.tooling.type.propagation.utils.TypePropagationResolverUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.module.soapkit.metadata.api.Metadata;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeFactory;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;

public class CFGTypePropagationSession
implements TypePropagationSession {
    private final ArtifactAst application;
    private final InternalMuleFramework framework;
    private final ChainExecutionPathTreeFactory cfgFactory;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private final Optional<org.mule.runtime.apikit.metadata.api.Metadata> apikitMetadataResolver;
    private final Optional<Metadata> soapkitMetadataResolver;
    private final Set<String> ongoingPropagations = new HashSet<String>();

    public CFGTypePropagationSession(InternalMuleFramework framework, ArtifactAst application) {
        this.framework = framework;
        this.application = application;
        this.cfgFactory = new ChainExecutionPathTreeFactory(application);
        this.expressionLanguageMetadataService = framework.getExpressionLanguageMetadataService();
        this.apikitMetadataResolver = ApiKitUtils.buildApiKitMetadataResolver(application, framework.getApiKitMetadataService(), framework.getExecutionClassLoader());
        this.soapkitMetadataResolver = ApiKitUtils.buildSoapKitMetadataResolver(application, framework.getExecutionClassLoader());
    }

    private Optional<ComponentAst> componentFromLocation(ComponentLocation location) {
        return this.application.recursiveStream().filter(comp -> comp.getLocation().getLocation().equals(location.getRootContainerName())).findFirst();
    }

    public CompletableFuture<TypePropagationResult> resolveAndPropagateTypes(TypePropagationRequest request) {
        ComponentLocation location = request.propagationTarget();
        Optional<ComponentAst> componentAst = this.componentFromLocation(location);
        if (!componentAst.isPresent()) {
            return CompletableFuture.completedFuture(DefaultTypePropagationResult.failure(Collections.singletonList(I18nMessageFactory.createStaticMessage((String)String.format("Incorrect location: %s", location.getLocation())))));
        }
        this.ongoingPropagations.add(location.getRootContainerName());
        ChainExecutionPathTree tree = this.cfgFactory.generateFor(componentAst.get());
        TypePropagationCFGVisitor visitor = new TypePropagationCFGVisitor(this.framework, this.expressionLanguageMetadataService, location);
        this.setInitialPayload(request, tree, visitor);
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        this.ongoingPropagations.remove(location.getRootContainerName());
        return CompletableFuture.completedFuture(TypePropagationResolverUtils.resolve(componentAst.get(), request, visitor, visitor.getUpdatedModels()));
    }

    private boolean hasSource(ChainExecutionPathTree tree) {
        Reference reference = new Reference((Object)false);
        tree.anyExecutionPathContains(node -> {
            reference.set((Object)node.getComponentAst().getModel(SourceModel.class).isPresent());
            return true;
        });
        return (Boolean)reference.get();
    }

    private void setInitialPayload(TypePropagationRequest request, ChainExecutionPathTree tree, TypePropagationCFGVisitor visitor) {
        if (request.getInitialMetadataTypeOverride().isPresent()) {
            visitor.initialMessage((MessageMetadataType)request.getInitialMetadataTypeOverride().get());
            return;
        }
        this.apikitMetadataResolver.ifPresent(metadataResolver -> ApiKitUtils.setInitialPayloadOfApiKitFlow(metadataResolver, request.propagationTarget().getRootContainerName(), visitor));
        this.soapkitMetadataResolver.ifPresent(metadataResolver -> ApiKitUtils.setInitialPayloadOfSoapKitFlow(metadataResolver, request.propagationTarget().getRootContainerName(), visitor));
        if (this.hasSource(tree)) {
            return;
        }
        String flowName = request.propagationTarget().getRootContainerName();
        Set<ComponentLocation> flowsRefsToFlowOfInterest = this.application.recursiveStream().filter(componentAst -> componentAst.getIdentifier().equals(CoreUtils.FLOW_REF_IDENTIFIER)).filter(flowRef -> {
            String reference = flowRef.getParameter("General", "name").getRawValue();
            return reference != null && reference.equals(flowName);
        }).map(ComponentAst::getLocation).filter(location -> !this.ongoingPropagations.contains(location.getRootContainerName())).collect(Collectors.toSet());
        if (flowsRefsToFlowOfInterest.isEmpty()) {
            return;
        }
        LinkedHashSet<MetadataType> payloadTypes = new LinkedHashSet<MetadataType>();
        LinkedHashSet<MetadataType> attributesTypes = new LinkedHashSet<MetadataType>();
        flowsRefsToFlowOfInterest.forEach(flowRef -> {
            try {
                Optional flowRefResult = this.resolveAndPropagateTypes((TypePropagationRequest)new BaseTypePropagationRequest(flowRef)).get().getTypedComponent(flowRef);
                flowRefResult.ifPresent(result -> {
                    result.getInputPayloadType().map(TypedEventField::getType).ifPresent(payloadTypes::add);
                    result.getInputAttributesType().map(TypedEventField::getType).ifPresent(attributesTypes::add);
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        if (!payloadTypes.isEmpty()) {
            visitor.initialPayload(this.toSingleMetadataType(payloadTypes));
        }
        if (!attributesTypes.isEmpty()) {
            visitor.initialAttributes(this.toSingleMetadataType(attributesTypes));
        }
    }

    private MetadataType toSingleMetadataType(Set<MetadataType> types) {
        if (types.size() == 1) {
            return types.iterator().next();
        }
        UnionTypeBuilder builder = new BaseTypeBuilder(MetadataFormat.JAVA).unionType().flattens().removesRepetitions();
        types.forEach(arg_0 -> ((UnionTypeBuilder)builder).of(arg_0));
        return builder.build();
    }
}

