/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.extension.config;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.framework.api.extension.config.ConfigurationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationHandlerRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationHandlerRegistry.class);
    private final Map<String, ConfigurationHandler> configurationHandlers = new ConcurrentHashMap<String, ConfigurationHandler>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public void registerConfigurationHandler(ConfigurationHandler configurationHandler) {
        this.writeLock.lock();
        String name = configurationHandler.getName();
        try {
            if (this.configurationHandlers.containsKey(name)) {
                throw new IllegalStateException("A configuration named '" + name + "' already exists");
            }
            this.configurationHandlers.put(name, configurationHandler);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void unregisterConfigurationHandler(ConfigurationHandler configurationHandler) {
        this.writeLock.lock();
        try {
            this.configurationHandlers.remove(configurationHandler.getName());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Optional<ConfigurationHandler> getConfigurationHandler(String name) {
        this.readLock.lock();
        try {
            Optional<ConfigurationHandler> optional = Optional.ofNullable(this.configurationHandlers.get(name));
            return optional;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(ConfigurationHandler configurationHandler) {
        String name = configurationHandler.getName();
        this.readLock.lock();
        try {
            ConfigurationHandler registered = this.configurationHandlers.get(name);
            if (registered == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = registered.equals(configurationHandler);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void closeAllConfigs() {
        this.writeLock.lock();
        try {
            this.configurationHandlers.values().forEach(config -> {
                try {
                    config.close();
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Could not close config %s during framework shutdown: %s", config.getName(), e.getMessage()), (Throwable)e);
                }
            });
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

