/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.framework.api.MuleFramework;
import org.mule.framework.api.ServiceConfigurer;
import org.mule.framework.api.builder.FrameworkApplicationConfigurer;
import org.mule.framework.api.builder.FrameworkDomainConfigurer;
import org.mule.framework.api.connectivity.OCSConfigurer;
import org.mule.framework.api.dependency.DependencyResolver;
import org.mule.framework.api.dependency.maven.DefaultMuleFrameworkDependencyResolver;
import org.mule.framework.api.exception.FrameworkBuildException;
import org.mule.framework.internal.DietMuleFramework;
import org.mule.framework.internal.DietMuleFrameworkStaticAnalysis;
import org.mule.framework.internal.DietMuleFrameworkWithConfigurations;
import org.mule.framework.internal.DietMuleFrameworkWithExtensionModels;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.builder.application.AbstractFrameworkApplicationConfigurer;
import org.mule.framework.internal.builder.application.FrameworkApplication;
import org.mule.framework.internal.builder.application.FrameworkApplicationFromDescriptorConfigurer;
import org.mule.framework.internal.builder.application.FrameworkApplicationFromPackagedProjectConfigurer;
import org.mule.framework.internal.builder.application.FrameworkApplicationFromPluginsConfigurer;
import org.mule.framework.internal.builder.application.FrameworkApplicationFromProjectSourcesConfigurer;
import org.mule.framework.internal.builder.application.InternalFrameworkApplicationConfigurer;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.framework.internal.builder.domain.AbstractFrameworkDomainConfigurer;
import org.mule.framework.internal.builder.domain.FrameworkDomain;
import org.mule.framework.internal.builder.domain.FrameworkDomainFromDescriptorConfigurer;
import org.mule.framework.internal.builder.domain.FrameworkDomainFromPackagedProjectConfigurer;
import org.mule.framework.internal.builder.domain.FrameworkDomainFromProjectSourcesConfigurer;
import org.mule.framework.internal.builder.domain.InternalFrameworkDomainConfigurer;
import org.mule.framework.internal.builder.service.MuleFrameworkServiceConfigurerBuilder;
import org.mule.framework.internal.context.MuleFrameworkContextFactory;
import org.mule.framework.internal.service.ConfigurationPropertiesDelegator;
import org.mule.framework.internal.tooling.type.resolution.NullMetadataStorage;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.MetadataStorage;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelDiscoverer;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.service.api.manager.ServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DietMuleFrameworkBuilder
implements MuleFramework.Builder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DietMuleFrameworkBuilder.class);
    private static final MetadataStorage DEFAULT_METADATA_CACHE = new NullMetadataStorage();
    private final Supplier<DependencyResolver> DEFAULT_DEPENDENCY_RESOLVER = new LazyValue(DefaultMuleFrameworkDependencyResolver::new);
    private final MuleFramework.UsageMode DEFAULT_USAGE_MODE = MuleFramework.UsageMode.EXECUTABLE;
    private final ArtifactClassLoader containerClassLoader;
    private final ArtifactClassLoaderResolver classLoaderResolver;
    private Supplier<DependencyResolver> dependencyResolver = this.DEFAULT_DEPENDENCY_RESOLVER;
    private OCSConfigurer ocsConfigurer;
    private MuleFrameworkServiceConfigurerBuilder servicesConfigurerBuilder;
    private MetadataStorage metadataCache = DEFAULT_METADATA_CACHE;
    private final Map<String, Object> customParameters = new HashMap<String, Object>();
    private InternalFrameworkApplicationConfigurer frameworkApplicationConfigurer;
    private InternalFrameworkDomainConfigurer frameworkDomainConfigurer;
    private MuleFramework.UsageMode usageMode = this.DEFAULT_USAGE_MODE;

    public DietMuleFrameworkBuilder(ArtifactClassLoader containerClassLoader, ArtifactClassLoaderResolver classLoaderResolver) {
        this.containerClassLoader = containerClassLoader;
        this.classLoaderResolver = classLoaderResolver;
    }

    public MuleFramework.Builder fromApplicationDescriptor(ApplicationDescriptor applicationDescriptor) {
        return this.fromApplicationDescriptor(applicationDescriptor, applicationConfigurer -> {});
    }

    public MuleFramework.Builder fromApplicationDescriptor(ApplicationDescriptor applicationDescriptor, Consumer<FrameworkApplicationConfigurer> applicationConfigurerConsumer) {
        if (applicationDescriptor == null) {
            throw new IllegalArgumentException("'applicationDescriptor' cannot be null");
        }
        this.configureApplication(applicationConfigurerConsumer, new FrameworkApplicationFromDescriptorConfigurer(applicationDescriptor));
        return this;
    }

    public MuleFramework.Builder fromApplicationProject(Path applicationPath) throws IllegalStateException, IllegalArgumentException {
        return this.fromApplicationProject(applicationPath, applicationConfigurer -> {});
    }

    public MuleFramework.Builder fromApplicationProject(Path applicationPath, Consumer<FrameworkApplicationConfigurer> applicationConfigurerConsumer) throws IllegalStateException, IllegalArgumentException {
        if (applicationPath == null) {
            throw new IllegalArgumentException("'applicationPath' cannot be null");
        }
        this.configureApplication(applicationConfigurerConsumer, new FrameworkApplicationFromProjectSourcesConfigurer(applicationPath));
        return this;
    }

    public MuleFramework.Builder fromPackagedApplication(Path packagedApplicationPath) throws IllegalStateException, IllegalArgumentException {
        return this.fromPackagedApplication(packagedApplicationPath, applicationConfigurer -> {});
    }

    public MuleFramework.Builder fromPackagedApplication(Path packagedApplicationPath, Consumer<FrameworkApplicationConfigurer> applicationConfigurerConsumer) throws IllegalStateException, IllegalArgumentException {
        return this.fromPackagedApplication(packagedApplicationPath, applicationConfigurerConsumer, false);
    }

    public MuleFramework.Builder fromPackagedApplication(Path packagedApplicationPath, boolean forceConfigsParse) throws IllegalStateException, IllegalArgumentException {
        return this.fromPackagedApplication(packagedApplicationPath, applicationConfigurer -> {}, forceConfigsParse);
    }

    public MuleFramework.Builder fromPackagedApplication(Path packagedApplicationPath, Consumer<FrameworkApplicationConfigurer> applicationConfigurerConsumer, boolean forceConfigsParse) throws IllegalStateException, IllegalArgumentException {
        if (packagedApplicationPath == null) {
            throw new IllegalArgumentException("'packagedApplicationPath' cannot be null");
        }
        this.configureApplication(applicationConfigurerConsumer, new FrameworkApplicationFromPackagedProjectConfigurer(packagedApplicationPath, forceConfigsParse));
        return this;
    }

    public MuleFramework.Builder fromDomainDescriptor(DomainDescriptor domainDescriptor) throws IllegalStateException, IllegalArgumentException {
        return this.fromDomainDescriptor(domainDescriptor, domainConfigurer -> {});
    }

    public MuleFramework.Builder fromDomainDescriptor(DomainDescriptor domainDescriptor, Consumer<FrameworkDomainConfigurer> domainConfigurerConsumer) throws IllegalStateException, IllegalArgumentException {
        if (domainDescriptor == null) {
            throw new IllegalArgumentException("'domainDescriptor' cannot be null");
        }
        this.configureDomain(domainConfigurerConsumer, new FrameworkDomainFromDescriptorConfigurer(domainDescriptor));
        return this;
    }

    public MuleFramework.Builder fromDomainProject(Path domainPath) throws IllegalStateException, IllegalArgumentException {
        return this.fromDomainProject(domainPath, domainConfigurer -> {});
    }

    public MuleFramework.Builder fromDomainProject(Path domainPath, Consumer<FrameworkDomainConfigurer> domainConfigurerConsumer) throws IllegalStateException, IllegalArgumentException {
        if (domainPath == null) {
            throw new IllegalArgumentException("'domainPath' cannot be null");
        }
        this.configureDomain(domainConfigurerConsumer, new FrameworkDomainFromProjectSourcesConfigurer(domainPath));
        return this;
    }

    public MuleFramework.Builder fromPackagedDomain(Path packagedDomainPath) throws IllegalStateException, IllegalArgumentException {
        return this.fromPackagedDomain(packagedDomainPath, domainConfigurer -> {});
    }

    public MuleFramework.Builder fromPackagedDomain(Path packagedDomainPath, Consumer<FrameworkDomainConfigurer> domainConfigurerConsumer) throws IllegalStateException, IllegalArgumentException {
        return this.fromPackagedDomain(packagedDomainPath, domainConfigurerConsumer, false);
    }

    public MuleFramework.Builder fromPackagedDomain(Path packagedDomainPath, boolean forceConfigsParse) throws IllegalStateException, IllegalArgumentException {
        return this.fromPackagedDomain(packagedDomainPath, domainConfigurer -> {}, forceConfigsParse);
    }

    public MuleFramework.Builder fromPackagedDomain(Path packagedDomainPath, Consumer<FrameworkDomainConfigurer> domainConfigurerConsumer, boolean forceConfigsParse) throws IllegalStateException, IllegalArgumentException {
        if (packagedDomainPath == null) {
            throw new IllegalArgumentException("'packagedDomainPath' cannot be null");
        }
        this.configureDomain(domainConfigurerConsumer, new FrameworkDomainFromPackagedProjectConfigurer(packagedDomainPath, forceConfigsParse));
        return this;
    }

    public MuleFramework.Builder fromPlugins(Consumer<FrameworkApplicationConfigurer> applicationConfigurerConsumer) {
        this.configureApplication(applicationConfigurerConsumer, new FrameworkApplicationFromPluginsConfigurer(this.dependencyResolver.get()));
        return this;
    }

    private void configureApplication(Consumer<FrameworkApplicationConfigurer> applicationConfigurerConsumer, AbstractFrameworkApplicationConfigurer applicationConfigurer) {
        if (applicationConfigurerConsumer == null) {
            throw new IllegalArgumentException("'applicationConfigurerConsumer' cannot be null");
        }
        if (this.frameworkApplicationConfigurer != null) {
            throw new IllegalStateException("'applicationConfigurer' is already set");
        }
        if (this.frameworkDomainConfigurer != null) {
            throw new IllegalStateException("'domainConfigurer' is already set");
        }
        this.frameworkApplicationConfigurer = applicationConfigurer;
        applicationConfigurerConsumer.accept(this.frameworkApplicationConfigurer);
    }

    private void configureDomain(Consumer<FrameworkDomainConfigurer> domainConfigurerConsumer, AbstractFrameworkDomainConfigurer domainConfigurer) {
        if (domainConfigurerConsumer == null) {
            throw new IllegalArgumentException("'domainConfigurerConsumer' cannot be null");
        }
        if (this.frameworkDomainConfigurer != null) {
            throw new IllegalStateException("'domainConfigurer' is already set");
        }
        if (this.frameworkApplicationConfigurer != null) {
            throw new IllegalStateException("'applicationConfigurer' is already set");
        }
        this.frameworkDomainConfigurer = domainConfigurer;
        domainConfigurerConsumer.accept(this.frameworkDomainConfigurer);
    }

    public MuleFramework.Builder withDependencyResolver(DependencyResolver dependencyResolver) {
        if (dependencyResolver == null) {
            throw new IllegalArgumentException("'dependencyResolver' cannot be null");
        }
        if (this.dependencyResolver != this.DEFAULT_DEPENDENCY_RESOLVER) {
            throw new IllegalStateException("'dependencyResolver' is already set");
        }
        this.dependencyResolver = () -> dependencyResolver;
        return this;
    }

    public MuleFramework.Builder enableOCS(Consumer<OCSConfigurer> configurer) {
        if (this.ocsConfigurer != null) {
            throw new IllegalStateException("OCS has already been configured");
        }
        this.ocsConfigurer = new OCSConfigurer();
        configurer.accept(this.ocsConfigurer);
        return this;
    }

    public MuleFramework.Builder usageMode(MuleFramework.UsageMode usageMode) {
        if (this.usageMode != this.DEFAULT_USAGE_MODE) {
            throw new IllegalStateException("'usageMode' is already set");
        }
        this.usageMode = usageMode;
        return this;
    }

    public MuleFramework.Builder withCustomServicesConfigurer(Consumer<ServiceConfigurer> configurer) {
        if (this.servicesConfigurerBuilder != null) {
            throw new IllegalStateException("'customServicesConfigurerBuilder' is already set");
        }
        this.servicesConfigurerBuilder = new MuleFrameworkServiceConfigurerBuilder(this.containerClassLoader, this.dependencyResolver.get());
        configurer.accept(this.servicesConfigurerBuilder);
        return this;
    }

    public MuleFramework.Builder withMetadataStorage(MetadataStorage metadataStorage) {
        this.metadataCache = metadataStorage;
        return this;
    }

    public MuleFramework.Builder addParameter(String key, Object value) {
        Preconditions.checkArgument((key != null && key.length() > 0 ? 1 : 0) != 0, (String)"key cannot be blank");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"value cannot be null");
        this.customParameters.put(key, value);
        return this;
    }

    public MuleFramework.Builder addParameters(Map<String, Object> parameters) {
        Preconditions.checkArgument((parameters != null ? 1 : 0) != 0, (String)"cannot add null parameters");
        parameters.forEach(this::addParameter);
        return this;
    }

    public MuleFramework build() {
        try {
            if (this.frameworkDomainConfigurer != null) {
                return this.buildForDomain();
            }
            return this.buildForApp();
        }
        catch (Exception e) {
            throw new FrameworkBuildException(e.getMessage(), (Throwable)e);
        }
    }

    private MuleFramework buildForDomain() {
        FrameworkDomain frameworkDomain = this.frameworkDomainConfigurer.configure(this.classLoaderResolver, this.getDeploymentPropertiesForArtifact());
        return this.buildForDeployableArtifact(frameworkDomain, () -> this.getExtensionModels(frameworkDomain.getClassLoader()));
    }

    private MuleFramework buildForApp() {
        if (this.frameworkApplicationConfigurer == null) {
            this.frameworkApplicationConfigurer = new FrameworkApplicationFromPluginsConfigurer(this.dependencyResolver.get());
        }
        FrameworkApplication frameworkApplication = this.frameworkApplicationConfigurer.configure(this.classLoaderResolver, this.getDeploymentPropertiesForArtifact());
        return this.buildForDeployableArtifact(frameworkApplication, () -> this.getExtensionModels(frameworkApplication.getClassLoader()));
    }

    private MuleFramework buildForDeployableArtifact(FrameworkDeployableArtifact frameworkDeployableArtifact, Supplier<Set<ExtensionModel>> extensionModelsSupplier) {
        try {
            Set<ExtensionModel> extensionModels = extensionModelsSupplier.get();
            if (this.frameworkApplicationConfigurer != null) {
                this.frameworkApplicationConfigurer.getDomainFramework().ifPresent(d -> d.getExtensionModels().forEach(extensionModels::add));
            }
            switch (this.usageMode) {
                case EXTENSION_MODELS: {
                    DietMuleFrameworkWithExtensionModels dietMuleFrameworkWithExtensionModels = new DietMuleFrameworkWithExtensionModels(frameworkDeployableArtifact, extensionModels);
                    return dietMuleFrameworkWithExtensionModels;
                }
                case ARTIFACT_AST: {
                    DietMuleFrameworkStaticAnalysis dietMuleFrameworkStaticAnalysis = this.getStaticAnalysisFramework(frameworkDeployableArtifact, extensionModels);
                    return dietMuleFrameworkStaticAnalysis;
                }
                case EXECUTABLE: {
                    InternalMuleFramework internalMuleFramework = this.getFullFledgedFramework(frameworkDeployableArtifact, extensionModels, this.frameworkApplicationConfigurer != null ? this.frameworkApplicationConfigurer.getDomainFramework() : Optional.empty());
                    return internalMuleFramework;
                }
            }
            throw new IllegalStateException("Unknown 'usageMode'");
        }
        finally {
            if (!(this.dependencyResolver instanceof LazyValue) || ((LazyValue)this.dependencyResolver).isComputed()) {
                LifecycleUtils.disposeIfNeeded((Object)this.dependencyResolver.get(), (Logger)LOGGER);
            }
        }
    }

    private DietMuleFrameworkStaticAnalysis getStaticAnalysisFramework(FrameworkDeployableArtifact frameworkDeployableArtifact, Set<ExtensionModel> extensionModels) {
        frameworkDeployableArtifact.setUp(extensionModels);
        return new DietMuleFrameworkStaticAnalysis(frameworkDeployableArtifact, extensionModels);
    }

    private InternalMuleFramework getFullFledgedFramework(FrameworkDeployableArtifact frameworkDeployableArtifact, Set<ExtensionModel> extensionModels, Optional<InternalMuleFramework> domainFwk) {
        if (this.servicesConfigurerBuilder == null) {
            this.servicesConfigurerBuilder = new MuleFrameworkServiceConfigurerBuilder(this.containerClassLoader, this.dependencyResolver.get());
        }
        ServiceManager serviceManager = this.servicesConfigurerBuilder.getServiceManager();
        MuleContext muleContext = null;
        MuleDeployableArtifactClassLoader applicationClassLoader = frameworkDeployableArtifact.getClassLoader();
        try {
            LifecycleUtils.startIfNeeded((Object)serviceManager);
            muleContext = this.createMuleContext(frameworkDeployableArtifact.getArtifactType(), serviceManager, extensionModels, (RegionClassLoader)applicationClassLoader.getParent());
            Registry registry = this.getRegistry(muleContext);
            ExpressionLanguageMetadataService expressionLanguageMetadataService = this.lookup(registry, ExpressionLanguageMetadataService.class);
            frameworkDeployableArtifact.setUp(muleContext, expressionLanguageMetadataService, extensionModels);
            registry.lookupByType(ConfigurationProperties.class).filter(ConfigurationPropertiesDelegator.class::isInstance).map(ConfigurationPropertiesDelegator.class::cast).ifPresent(cpd -> cpd.setDelegate((ConfigurationProperties)frameworkDeployableArtifact.getConfigurationProperties()));
            DietMuleFramework mule = frameworkDeployableArtifact.isCreateConfigurations() ? new DietMuleFrameworkWithConfigurations(muleContext, registry, serviceManager, extensionModels, frameworkDeployableArtifact, domainFwk, expressionLanguageMetadataService, this.metadataCache) : new DietMuleFramework(muleContext, registry, serviceManager, extensionModels, frameworkDeployableArtifact, domainFwk, expressionLanguageMetadataService, this.metadataCache);
            mule.start();
            return mule;
        }
        catch (MuleException e) {
            try {
                serviceManager.stop();
            }
            catch (MuleException e1) {
                e1.addSuppressed((Throwable)e);
                throw new MuleRuntimeException((Throwable)e1);
            }
            finally {
                LifecycleUtils.disposeIfNeeded(muleContext, (Logger)LOGGER);
            }
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Registry getRegistry(MuleContext muleContext) throws MuleException {
        MuleFrameworkRegistry muleFrameworkRegistry = new MuleFrameworkRegistry();
        muleContext.getInjector().inject((Object)muleFrameworkRegistry);
        return muleFrameworkRegistry.getRegistry();
    }

    private Set<ExtensionModel> getExtensionModels(MuleDeployableArtifactClassLoader applicationClassLoader) {
        ExtensionModelLoaderRepository extensionModelLoaderRepository = ExtensionModelLoaderRepository.getExtensionModelLoaderManager();
        try {
            LifecycleUtils.startIfNeeded((Object)extensionModelLoaderRepository);
            ExtensionModelDiscoverer extensionModelDiscoverer = ExtensionModelDiscoverer.defaultExtensionModelDiscoverer((MuleDeployableArtifactClassLoader)applicationClassLoader, (ExtensionModelLoaderRepository)extensionModelLoaderRepository);
            Set set = extensionModelDiscoverer.discoverPluginsExtensionModels(this.getExtensionDiscoveryRequest((DeployableArtifactDescriptor)applicationClassLoader.getArtifactDescriptor()));
            return set;
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        finally {
            try {
                LifecycleUtils.stopIfNeeded((Object)extensionModelLoaderRepository);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    private MuleContext createMuleContext(ArtifactType artifactType, ServiceManager serviceManager, Set<ExtensionModel> extensionModels, RegionClassLoader executionClassLoader) {
        MuleFrameworkContextFactory factory = new MuleFrameworkContextFactory();
        try {
            return factory.createMuleContext(artifactType, serviceManager.getServices(), extensionModels, (ClassLoader)executionClassLoader);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create framework mule context"), (Throwable)e);
        }
    }

    private <T> T lookup(Registry registry, Class<T> clazz) {
        return registry.lookupByType(clazz).orElse(null);
    }

    private ExtensionDiscoveryRequest getExtensionDiscoveryRequest(DeployableArtifactDescriptor deployableArtifactDescriptor) {
        return ExtensionDiscoveryRequest.builder().setArtifactPlugins((Collection)deployableArtifactDescriptor.getPlugins()).setOCSEnabled(this.ocsConfigurer != null).setParallelDiscovery(true).addParameters(this.customParameters).build();
    }

    private Map<String, String> getDeploymentPropertiesForArtifact() {
        return this.ocsConfigurer != null ? this.getOCSConfiguration(this.ocsConfigurer) : Collections.emptyMap();
    }

    private Map<String, String> getOCSConfiguration(OCSConfigurer ocsConfigurer) {
        Preconditions.checkArgument((ocsConfigurer.getAuthUrl() != null ? 1 : 0) != 0, (String)"The authUrl cannot be null in OCS configuration");
        Preconditions.checkArgument((ocsConfigurer.getServiceUrl() != null ? 1 : 0) != 0, (String)"The serviceUrl cannot be null in OCS configuration");
        Preconditions.checkArgument((ocsConfigurer.getClientId() != null ? 1 : 0) != 0, (String)"The clientId cannot be null in OCS configuration");
        Preconditions.checkArgument((ocsConfigurer.getClientSecret() != null ? 1 : 0) != 0, (String)"The clientSecret cannot be null in OCS configuration");
        Preconditions.checkArgument((ocsConfigurer.getOrgId() != null ? 1 : 0) != 0, (String)"The orgId cannot be null in OCS configuration");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("ocs.service.url", ocsConfigurer.getServiceUrl());
        configuration.put("ocs.platform.authentication.url", ocsConfigurer.getAuthUrl());
        configuration.put("ocs.service.client.id", ocsConfigurer.getClientId());
        configuration.put("ocs.service.client.secret", ocsConfigurer.getClientSecret());
        configuration.put("csorganization.id", ocsConfigurer.getOrgId());
        if (ocsConfigurer.getPlatformAuthPath() != null) {
            configuration.put("ocs.platform.authentication.path", ocsConfigurer.getPlatformAuthPath());
        }
        if (ocsConfigurer.getApiVersion() != null) {
            configuration.put("ocs.api.version", ocsConfigurer.getApiVersion());
        }
        return Collections.unmodifiableMap(configuration);
    }

    private static class MuleFrameworkRegistry {
        @Inject
        Registry registry;

        private MuleFrameworkRegistry() {
        }

        public Registry getRegistry() {
            return this.registry;
        }
    }
}

