/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.api.dependency.maven;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.api.annotation.Experimental;
import org.mule.framework.api.dependency.DependencyResolutionException;
import org.mule.framework.api.dependency.DependencyResolver;
import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;

@Experimental
public class DefaultMuleFrameworkDependencyResolver
implements DependencyResolver {
    private final MavenClient mavenClient;
    private static final MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)MavenClientProvider.class.getClassLoader());

    public DefaultMuleFrameworkDependencyResolver() {
        this(DefaultMuleFrameworkDependencyResolver.getDefaultMavenConfiguration());
    }

    public DefaultMuleFrameworkDependencyResolver(MavenConfiguration mavenConfig) {
        this.mavenClient = mavenClientProvider.createMavenClient(mavenConfig);
    }

    private static MavenConfiguration getDefaultMavenConfiguration() {
        Supplier localMavenRepository = mavenClientProvider.getLocalRepositorySuppliers().environmentMavenRepositorySupplier();
        SettingsSupplierFactory settingsSupplierFactory = mavenClientProvider.getSettingsSupplierFactory();
        Optional globalSettings = settingsSupplierFactory.environmentGlobalSettingsSupplier();
        Optional userSettings = settingsSupplierFactory.environmentUserSettingsSupplier();
        Optional settingsSecurity = settingsSupplierFactory.environmentSettingsSecuritySupplier();
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().forcePolicyUpdateNever(true).localMavenRepositoryLocation((File)localMavenRepository.get());
        globalSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).globalSettingsLocation(arg_0));
        userSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).userSettingsLocation(arg_0));
        settingsSecurity.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        return mavenConfigurationBuilder.build();
    }

    public BundleDependency resolveFor(org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor bundleDescriptor) throws DependencyResolutionException {
        List transitiveDeps;
        org.mule.maven.pom.parser.api.model.BundleDependency resolvedBundleDependency;
        BundleDescriptor mavenBundleDescriptor = new BundleDescriptor.Builder().setGroupId(bundleDescriptor.getGroupId()).setArtifactId(bundleDescriptor.getArtifactId()).setVersion(bundleDescriptor.getVersion()).setBaseVersion(bundleDescriptor.getBaseVersion()).setType(bundleDescriptor.getType()).setClassifier((String)bundleDescriptor.getClassifier().orElse(null)).build();
        try {
            resolvedBundleDependency = this.mavenClient.resolveBundleDescriptor(mavenBundleDescriptor);
            transitiveDeps = this.mavenClient.resolveBundleDescriptorDependencies(false, mavenBundleDescriptor);
        }
        catch (BundleDependenciesResolutionException e) {
            throw new DependencyResolutionException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), (Throwable)e);
        }
        return new BundleDependency.Builder().setDescriptor(this.mavenToMuleDescriptor(resolvedBundleDependency.getDescriptor())).setScope(BundleScope.valueOf((String)resolvedBundleDependency.getScope().name())).setBundleUri(resolvedBundleDependency.getBundleUri()).setTransitiveDependencies(transitiveDeps.stream().map(this::mavenToMuleDependency).collect(Collectors.toList())).build();
    }

    private org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor mavenToMuleDescriptor(BundleDescriptor mavenBundleDescriptor) {
        return new BundleDescriptor.Builder().setGroupId(mavenBundleDescriptor.getGroupId()).setArtifactId(mavenBundleDescriptor.getArtifactId()).setVersion(mavenBundleDescriptor.getVersion()).setBaseVersion(mavenBundleDescriptor.getBaseVersion()).setType(mavenBundleDescriptor.getType()).setClassifier((String)mavenBundleDescriptor.getClassifier().orElse(null)).build();
    }

    private BundleDependency mavenToMuleDependency(org.mule.maven.pom.parser.api.model.BundleDependency mavenBundleDependency) {
        return new BundleDependency.Builder().setDescriptor(this.mavenToMuleDescriptor(mavenBundleDependency.getDescriptor())).setScope(BundleScope.valueOf((String)mavenBundleDependency.getScope().name())).setBundleUri(mavenBundleDependency.getBundleUri()).setTransitiveDependencies(mavenBundleDependency.getTransitiveDependencies().stream().map(this::mavenToMuleDependency).collect(Collectors.toList())).build();
    }

    public void dispose() {
        try {
            this.mavenClient.close();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error while disposing dependency resolver"), (Throwable)e);
        }
    }
}

