/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.xa;

import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.ResourceConfigurationException;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import com.mulesoft.mule.runtime.bti.internal.xa.MuleXAConnectionHandlerResourceHolder;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.mule.runtime.api.alert.AlertingSupport;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.mule.sdk.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMuleXAResourceProducer
extends ResourceBean
implements XAResourceProducer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMuleXAResourceProducer.class);
    private transient AlertingSupport alertingSupport;
    private transient AtomicReference<ConnectionHandler<? extends XATransactionalConnection>> recoveryConnectionHandler = new AtomicReference();

    public void init() {
        try {
            ResourceRegistrar.register((XAResourceProducer)this);
        }
        catch (RecoveryException ex) {
            throw new ResourceConfigurationException("cannot init MuleXAConnectionHandlerResourceProducer for '" + this.getUniqueName() + "'", (Throwable)ex);
        }
    }

    public void close() {
        ResourceRegistrar.unregister((XAResourceProducer)this);
    }

    public XAResourceHolderState startRecovery() throws RecoveryException {
        if (this.recoveryConnectionHandler.get() != null) {
            throw new RecoveryException("recovery already in progress for '" + this.getUniqueName() + "'");
        }
        try {
            this.recoveryConnectionHandler.set(this.getRecoveryConnectionHandler());
            RecoveryXAResourceHolder recoveryXAResourceHolder = new RecoveryXAResourceHolder((XAResourceHolder)new MuleXAConnectionHandlerResourceHolder((ConnectionHandler<XATransactionalConnection>)((ConnectionHandlerAdapter)this.recoveryConnectionHandler.get()), (XATransactionalConnection)this.recoveryConnectionHandler.get().getConnection(), this));
            return new XAResourceHolderState((XAResourceHolder)recoveryXAResourceHolder, (ResourceBean)this);
        }
        catch (Exception e) {
            this.alertingSupport.triggerAlert("XA_RECOVERY_START_ERROR", (Object)this.getUniqueName());
            this.recoveryConnectionHandler.set(null);
            throw new RecoveryException("error starting recovery for '" + this.getUniqueName() + "'", (Throwable)e);
        }
    }

    public void endRecovery() throws RecoveryException {
        if (this.recoveryConnectionHandler.get() != null) {
            try {
                LOGGER.debug("recovery connection handle is being closed for '{}': {}", (Object)this.getUniqueName(), this.recoveryConnectionHandler.get());
                this.recoveryConnectionHandler.get().release();
            }
            catch (Exception e) {
                throw new RecoveryException("error ending recovery for '" + this.getUniqueName() + "'", (Throwable)e);
            }
            finally {
                this.recoveryConnectionHandler.set(null);
            }
        }
    }

    protected abstract ConnectionHandler<XATransactionalConnection> getRecoveryConnectionHandler() throws ConnectionException;

    public void setAlertingSupport(AlertingSupport alertingSupport) {
        this.alertingSupport = alertingSupport;
    }

    public Reference getReference() throws NamingException {
        throw new UnsupportedOperationException("JNDI not supported.");
    }
}

