/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.jms;

import com.mulesoft.mule.runtime.bti.api.jms.ConnectionFactoryDecorator;
import com.mulesoft.mule.runtime.bti.api.jms.JmsConnectionConfig;
import com.mulesoft.mule.runtime.bti.internal.jms.XAConnectionFactoryWrapper;
import jakarta.inject.Inject;
import jakarta.transaction.TransactionManager;
import javax.jms.ConnectionFactory;
import javax.jms.XAConnectionFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.privileged.registry.RegistrationException;

public abstract class AbstractConnectionFactoryDecorator
implements ConnectionFactoryDecorator {
    private MuleConfiguration muleConfiguration;
    private TransactionManager txManager;

    @Override
    public ConnectionFactory decorate(ConnectionFactory connectionFactory, JmsConnectionConfig jmsConfig, MuleContext muleContext) {
        if (!this.appliesTo(connectionFactory)) {
            throw new IllegalStateException("DefaultConnectionFactoryDecorator invoked but it shouldn't be called since it does not applies to the ConnectionFactory");
        }
        return this.doDecorate(connectionFactory, jmsConfig, this.muleConfiguration, this.txManager);
    }

    @Override
    public ConnectionFactory decorate(ConnectionFactory connectionFactory, JmsConnectionConfig jmsConfig) {
        if (!this.appliesTo(connectionFactory)) {
            throw new IllegalStateException("DefaultConnectionFactoryDecorator invoked but it shouldn't be called since it does not applies to the ConnectionFactory");
        }
        return this.doDecorate(connectionFactory, jmsConfig, this.muleConfiguration, this.txManager);
    }

    protected abstract ConnectionFactory doDecorate(ConnectionFactory var1, JmsConnectionConfig var2, MuleConfiguration var3, TransactionManager var4);

    protected boolean isXaConnectionFactory(ConnectionFactory connectionFactory) {
        return connectionFactory instanceof XAConnectionFactory;
    }

    protected boolean isConnectionFactoryWrapper(ConnectionFactory connectionFactory) {
        return connectionFactory instanceof XAConnectionFactoryWrapper;
    }

    protected TransactionManager lookupTransactionManager(MuleContext muleContext) {
        try {
            return (TransactionManager)((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(TransactionManager.class);
        }
        catch (RegistrationException e) {
            throw new IllegalStateException("No TransactionManager available", e);
        }
    }

    @Inject
    public void setMuleConfiguration(MuleConfiguration muleConfiguration) {
        this.muleConfiguration = muleConfiguration;
    }

    @Inject
    public void setTxManager(TransactionManager txManager) {
        this.txManager = txManager;
    }

    protected TransactionManager getTxManager() {
        return this.txManager;
    }
}

