/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.api.util;

import bitronix.tm.TransactionManagerServices;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.internal.util.MuleContainerUtils;
import org.mule.runtime.core.internal.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitronixConfigurationUtil {
    private static final Logger logger = LoggerFactory.getLogger(BitronixConfigurationUtil.class);
    public static final String BITRONIX_SERVER_ID = "mule.bitronix.serverId";
    public static final String BITRONIX_RECOVERY_INTERVAL = "mule.bitronix.recoveryinterval";
    public static final String BITRONIX_TRANSACTION_TIMEOUT = "mule.bitronix.transactiontimeout";
    public static final String CLUSTER_NODE_ID_PROPERTY = "mule.clusterNodeId";

    private BitronixConfigurationUtil() {
    }

    public static String createUniqueIdForServer() {
        String configuredBitronixServerId = System.getProperty(BITRONIX_SERVER_ID);
        if (configuredBitronixServerId != null) {
            return configuredBitronixServerId;
        }
        try {
            InetAddress address = NetworkUtils.getLocalHost();
            return String.valueOf(Math.abs(new HashCodeBuilder(17, 37).append((Object)address.getHostName()).append((Object)address.getHostName()).append((Object)System.getProperty(CLUSTER_NODE_ID_PROPERTY, "0")).toHashCode()));
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated(since="4.9.0")
    public static String createUniqueIdForResource(MuleContext muleContext, String resourceId) {
        return BitronixConfigurationUtil.createUniqueIdForResource(muleContext.getConfiguration(), resourceId);
    }

    public static String createUniqueIdForResource(MuleConfiguration muleConfiguration, String resourceId) {
        String uniqueResourceId = BitronixConfigurationUtil.createUniqueIdForServer() + "-" + muleConfiguration.getId() + "-" + resourceId;
        logger.info("Creating bitronix xa resource with id: {}", (Object)uniqueResourceId);
        return uniqueResourceId;
    }

    public static int getTransactionRecoveryIntervalInSeconds() {
        return Integer.valueOf(System.getProperty(BITRONIX_RECOVERY_INTERVAL, "60"));
    }

    public static void runTransactionRecovery() {
        TransactionManagerServices.getRecoverer().run();
    }

    public static String getLogPart2Filename() {
        return BitronixConfigurationUtil.getLogPartFilename(TransactionManagerServices.getConfiguration().getLogPart2Filename());
    }

    public static String getLogPart1Filename() {
        return BitronixConfigurationUtil.getLogPartFilename(TransactionManagerServices.getConfiguration().getLogPart1Filename());
    }

    private static String getLogPartFilename(String filename) {
        String muleBase = MuleContainerUtils.getMuleBase() != null ? MuleContainerUtils.getMuleBase().getAbsolutePath() : ".";
        String containerWorkingDirectory = muleBase + "/.mule";
        return containerWorkingDirectory + File.separator + "tx-log" + File.separator + filename;
    }

    public static int getTransactionTimeout() {
        return Integer.valueOf(System.getProperty(BITRONIX_TRANSACTION_TIMEOUT, "60"));
    }
}

