/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.internal.util.jar.JarLoadingUtils;

public class MuleArtifactPatchingModel {
    private static final String MULE_ARTIFACT_PATCH_JSON_FILE_NAME = "mule-artifact-patch.json";
    private static final Map<String, MuleArtifactPatchingModel> loadedModelByJar = new HashMap<String, MuleArtifactPatchingModel>();
    private ArtifactCoordinates artifactCoordinates;
    private List<String> affectedVersions;

    public static synchronized MuleArtifactPatchingModel loadModel(File pluginPatchJarFile) throws IOException {
        String key = pluginPatchJarFile.toString();
        if (!loadedModelByJar.containsKey(key)) {
            Optional muleArtifactPatchContent = JarLoadingUtils.loadFileContentFrom((File)pluginPatchJarFile, (String)MULE_ARTIFACT_PATCH_JSON_FILE_NAME);
            muleArtifactPatchContent.map(bytes -> {
                MuleArtifactPatchingModel artifactPatchingModel = MuleArtifactPatchingModel.deserialize(bytes);
                loadedModelByJar.put(key, artifactPatchingModel);
                return artifactPatchingModel;
            }).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Invalid jar file '%s'. It does not contain descriptor '%s'", pluginPatchJarFile, MULE_ARTIFACT_PATCH_JSON_FILE_NAME))));
        }
        return loadedModelByJar.get(key);
    }

    private static MuleArtifactPatchingModel deserialize(byte[] muleArtifactPatchBytes) {
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().registerTypeAdapter(ArtifactCoordinates.class, (Object)new ArtifactCoordinatesAdapter()).create();
        return (MuleArtifactPatchingModel)gson.fromJson(new String(muleArtifactPatchBytes), MuleArtifactPatchingModel.class);
    }

    public ArtifactCoordinates getArtifactCoordinates() {
        return this.artifactCoordinates;
    }

    public void setArtifactCoordinates(ArtifactCoordinates artifactCoordinates) {
        this.artifactCoordinates = artifactCoordinates;
    }

    public List<String> getAffectedVersions() {
        return this.affectedVersions;
    }

    public void setAffectedVersions(List<String> affectedVersions) {
        this.affectedVersions = affectedVersions;
    }

    public static class ArtifactCoordinatesAdapter
    implements JsonDeserializer<ArtifactCoordinates> {
        public ArtifactCoordinates deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            final String groupId = jsonObject.get("groupId").getAsString();
            final String artifactId = jsonObject.get("artifactId").getAsString();
            final Optional<String> classifier = Optional.ofNullable(jsonObject.get("classifier")).map(JsonElement::getAsString);
            return new ArtifactCoordinates(){

                public String getGroupId() {
                    return groupId;
                }

                public String getArtifactId() {
                    return artifactId;
                }

                public String getVersion() {
                    return null;
                }

                public Optional<String> getClassifier() {
                    return classifier;
                }
            };
        }
    }
}

