/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.internal.node.errorhandling;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlerNode;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlerWrapper;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlingExecutionPathNodeBuilder;

public class ErrorHandlingContext {
    private final LinkedList<ErrorHandlerNode> context = new LinkedList();

    public ErrorHandlingContext(boolean addNullEH) {
        if (addNullEH) {
            this.context.addFirst(new ErrorHandlingExecutionPathNodeBuilder(null).build());
        }
    }

    public ErrorHandlingContext() {
        this(false);
    }

    public Optional<ChainExecutionPathTree> getMatchingErrorHandlerFor(List<ErrorType> errorTypes) {
        HashMap<ErrorType, ErrorHandlerNode> handlers = new HashMap<ErrorType, ErrorHandlerNode>();
        errorTypes.forEach(err -> this.context.stream().filter(handler -> handler.appliesTo((ErrorType)err)).findFirst().ifPresent(handler -> handlers.put((ErrorType)err, (ErrorHandlerNode)handler)));
        return handlers.isEmpty() ? Optional.empty() : Optional.of(new ErrorHandlerWrapper(handlers));
    }

    public void addPropagateHandler(ErrorHandlerNode errorHandlingNode) {
        errorHandlingNode.setOuters(new LinkedList<ErrorHandlerNode>(this.context));
        this.context.addFirst(errorHandlingNode);
    }

    public void addContinueHandler(ErrorHandlerNode errorHandlingNode) {
        this.context.addFirst(errorHandlingNode);
    }

    public void removeLastHandlers(int count) {
        for (int i = 0; i < count; ++i) {
            this.context.removeFirst();
        }
    }
}

