/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.lexical.formatstype.BaseFormatter;
import com.mulesoft.lexical.formatstype.TypeFormatConverter;
import java.io.IOException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;

public abstract class TypeBaseFormat<A>
implements TypeFormat {
    private final String typeCode;
    private final int minLength;
    private final int maxLength;
    private final TypeFormatConverter<A, String> converter;
    private final BaseFormatter<A> formatter;

    public TypeBaseFormat(String code, int min, int max, TypeFormatConverter converter, BaseFormatter formatter) {
        if (max < min) {
            throw new IllegalArgumentException("Maximum length cannot be less than minimum length");
        }
        if (min < 0) {
            throw new IllegalArgumentException("Negative length is not allowed");
        }
        if (converter == null || formatter == null) {
            throw new IllegalArgumentException("Behavior for parse/write is needed");
        }
        this.typeCode = code;
        this.minLength = min;
        this.maxLength = max;
        this.converter = converter;
        this.formatter = formatter;
    }

    @Override
    public String typeCode() {
        return this.typeCode;
    }

    @Override
    public int minLength() {
        return this.minLength;
    }

    @Override
    public int maxLength() {
        return this.maxLength;
    }

    public int maxLength(String value) {
        return this.maxLength();
    }

    public int minLength(String value) {
        return this.minLength();
    }

    @Override
    public Object parse(LexerBase lexer) throws LexicalException {
        return this.converter.convert(lexer.token(), lexer, this);
    }

    @Override
    public void write(Object value, WriterBase writer) throws IOException {
        writer.writeToken(this.formatter.format(value, this, writer));
    }

    public TypeFormatConstants.FillMode getFillMode() {
        throw new NotImplementedException("not implemented");
    }

    public char getFill() {
        throw new NotImplementedException("not implemented");
    }

    public TypeFormatConstants.NumberSign getNumberSign() {
        throw new NotImplementedException("not implemented");
    }

    public boolean getZeroBeforeDecimal() {
        throw new NotImplementedException("not implemented");
    }

    public boolean getAllowExponent() {
        throw new NotImplementedException("not implemented");
    }

    public int getDecimalPosition() {
        throw new NotImplementedException("not implemented");
    }

    public String truncateToMaxLength(String value) {
        return StringUtils.substring((String)value, (int)0, (int)this.maxLength());
    }

    public boolean checkAllowedCharacters() {
        return false;
    }

    public boolean[] getAllowedChars() {
        throw new NotImplementedException("not implemented");
    }

    public boolean getOpenEnded() {
        throw new NotImplementedException("not implemented");
    }
}

