/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.model.EmptyPolicySpecification;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.model.ValidPolicySpecification;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicySpecificationBuilder {
    private final Logger LOGGER = LoggerFactory.getLogger(PolicySpecificationBuilder.class);
    private File yamlFile;

    public PolicySpecificationBuilder withFile(File yamlFile) {
        this.yamlFile = yamlFile;
        return this;
    }

    public PolicySpecification build() {
        if (this.yamlFile != null && this.yamlFile.exists()) {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            try {
                this.LOGGER.debug("Parsing yaml file {}", (Object)this.yamlFile.getName());
                return (PolicySpecification)mapper.readValue(this.yamlFile, ValidPolicySpecification.class);
            }
            catch (IOException e) {
                this.LOGGER.warn("Parsing yaml file {} failed: {}", (Object)this.yamlFile.getName(), (Object)ExceptionDescriptor.errorMessage((Throwable)e));
            }
        }
        return new EmptyPolicySpecification();
    }
}

