/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.factory;

import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.OfflinePolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.encryption.PolicyConfigurationEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.PolicyConfigurationEncryptionResult;
import com.mulesoft.mule.runtime.gw.policies.factory.DefaultPolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyConfigurationSanitizer;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactoryTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.PolicyTemplateResolver;
import java.util.Map;

public class EncryptedPolicyFactory
extends PolicyFactoryTemplate {
    private PolicyFactory defaultPolicyFactory;
    private PolicyConfigurationEncrypter policyConfigurationEncrypter;

    public EncryptedPolicyFactory(PolicyTemplateResolver templateResolver, PolicyTemplateProvider templateProvider, PolicyConfigurationEncrypter policyConfigurationEncrypter, PolicyConfigurationSanitizer policyConfigurationSanitizer) {
        super(templateResolver, templateProvider, policyConfigurationSanitizer);
        this.defaultPolicyFactory = new DefaultPolicyFactory(templateResolver, templateProvider, policyConfigurationSanitizer);
        this.policyConfigurationEncrypter = policyConfigurationEncrypter;
    }

    @Override
    public Policy createFromPolicyDefinition(PolicyDefinition policyDefinition) {
        PolicyTemplate policyTemplate = this.getPolicyTemplate(policyDefinition);
        if (policyTemplate.getPolicySpecification().isEncryptionSupported()) {
            return this.createFromPolicyDefinitionEncrypted(policyTemplate, policyDefinition);
        }
        return this.defaultPolicyFactory.createFromPolicyDefinition(policyDefinition);
    }

    private Policy createFromPolicyDefinitionEncrypted(PolicyTemplate policyTemplate, PolicyDefinition policyDefinition) {
        policyDefinition = this.policyConfigurationSanitizer.sanitizeAndValidate(policyDefinition, policyTemplate);
        PolicyConfigurationEncryptionResult policyConfigurationEncryptionResult = this.policyConfigurationEncrypter.encryptConfiguration(policyDefinition, policyTemplate.getPolicySpecification());
        Map<String, Object> policyDefinitionConfiguration = policyConfigurationEncryptionResult.getTemplatePlaceholders();
        String resolvedTemplate = this.resolveTemplate(policyTemplate, policyDefinitionConfiguration);
        Object encryptedPolicyDefinition = policyDefinition.isOnline() ? new PolicyDefinition(policyDefinition, this.resolvePolicyConfiguration(policyDefinition, policyConfigurationEncryptionResult)) : new OfflinePolicyDefinition(policyDefinition, this.resolvePolicyConfiguration(policyDefinition, policyConfigurationEncryptionResult));
        return new Policy(policyTemplate, (PolicyDefinition)encryptedPolicyDefinition, resolvedTemplate, policyConfigurationEncryptionResult.getConfigFileProperties());
    }

    private PolicyConfiguration resolvePolicyConfiguration(PolicyDefinition originalPolicyDefinition, PolicyConfigurationEncryptionResult policyConfigurationEncryptionResult) {
        return new PolicyConfiguration(policyConfigurationEncryptionResult.getConfigurationProperties().getConfiguration(), originalPolicyDefinition.getConfigurationData().getConfigurationVersion());
    }
}

