/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import java.util.Objects;

public class PolicyDefinitionDeploymentStatus {
    private final Exception exception;
    private final PolicyDefinition policyDefinition;
    protected final DeploymentStatus deploymentStatus;

    public PolicyDefinitionDeploymentStatus(PolicyDefinition policy) {
        this(policy, DeploymentStatus.DEPLOYMENT_SUCCESS, null);
    }

    public PolicyDefinitionDeploymentStatus(PolicyDefinition policyDefinition, DeploymentStatus applied, Exception e) {
        this.policyDefinition = policyDefinition;
        this.deploymentStatus = applied;
        this.exception = e;
    }

    public boolean isDeploymentSuccess() {
        return DeploymentStatus.DEPLOYMENT_SUCCESS.equals((Object)this.deploymentStatus);
    }

    public boolean isTemplateDownloadFailed() {
        return DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED.equals((Object)this.deploymentStatus);
    }

    public boolean isDeploymentFailed() {
        return DeploymentStatus.DEPLOYMENT_FAILED.equals((Object)this.deploymentStatus) || DeploymentStatus.REVERT_FAILED.equals((Object)this.deploymentStatus);
    }

    public boolean isRevertFailed() {
        return DeploymentStatus.REVERT_FAILED.equals((Object)this.deploymentStatus);
    }

    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    public Exception getException() {
        return this.exception;
    }

    public PolicyDefinition getPolicyDefinition() {
        return this.policyDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyDefinitionDeploymentStatus that = (PolicyDefinitionDeploymentStatus)o;
        return Objects.equals(this.exception, that.exception) && this.policyDefinition.equals((Object)that.policyDefinition) && this.deploymentStatus == that.deploymentStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.exception, this.policyDefinition, this.deploymentStatus});
    }

    public String toString() {
        return "PolicyDefinitionDeploymentStatus{exception=" + String.valueOf(this.exception) + ", policyDefinition=" + String.valueOf(this.policyDefinition) + ", deploymentStatus=" + String.valueOf((Object)this.deploymentStatus) + "}";
    }

    public static enum DeploymentStatus {
        DEPLOYMENT_SUCCESS,
        DEPLOYMENT_FAILED,
        REVERT_FAILED,
        TEMPLATE_DOWNLOAD_FAILED;

    }
}

