/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.util.ExceptionHandler;

public class ClassUtils {
    @Deprecated
    public static void withContextClassLoader(ClassLoader classLoader, Runnable runnable) {
        try {
            ClassUtils.withContextClassLoader(classLoader, runnable, RuntimeException.class, (Exception e) -> {
                throw new MuleRuntimeException((Throwable)e);
            });
        }
        catch (Exception e2) {
            throw new MuleRuntimeException((Throwable)e2);
        }
    }

    public static <T> T withContextClassLoader(ClassLoader classLoader, Callable<T> callable) {
        return (T)ClassUtils.withContextClassLoader(classLoader, callable, RuntimeException.class, (Exception e) -> {
            throw new MuleRuntimeException((Throwable)e);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> void withContextClassLoader(ClassLoader classLoader, Runnable runnable, Class<E> expectedExceptionType, ExceptionHandler<T, E> exceptionHandler) throws E {
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        if (currentClassLoader != classLoader) {
            currentThread.setContextClassLoader(classLoader);
        }
        try {
            ClassUtils.tryExpecting(expectedExceptionType, runnable, exceptionHandler);
        }
        finally {
            if (currentClassLoader != classLoader) {
                currentThread.setContextClassLoader(currentClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> T withContextClassLoader(ClassLoader classLoader, Callable<T> callable, Class<E> expectedExceptionType, ExceptionHandler<T, E> exceptionHandler) throws E {
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        if (currentClassLoader != classLoader) {
            currentThread.setContextClassLoader(classLoader);
        }
        try {
            T t = ClassUtils.tryExpecting(expectedExceptionType, callable, exceptionHandler);
            return t;
        }
        finally {
            if (currentClassLoader != classLoader) {
                currentThread.setContextClassLoader(currentClassLoader);
            }
        }
    }

    public static void setContextClassLoader(Thread thread, ClassLoader currentClassLoader, ClassLoader newClassLoader) {
        if (currentClassLoader != newClassLoader) {
            thread.setContextClassLoader(newClassLoader);
        }
    }

    public static <T, E extends Exception> T tryExpecting(Class<E> expectedExceptionType, Callable<T> callable, ExceptionHandler<T, E> exceptionHandler) throws E {
        try {
            return callable.call();
        }
        catch (Exception e) {
            if (expectedExceptionType.isInstance(e)) {
                throw e;
            }
            if (e instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)e;
                throw re;
            }
            return exceptionHandler.handle(e);
        }
    }

    private static <T, E extends Exception> void tryExpecting(Class<E> expectedExceptionType, Runnable runnable, ExceptionHandler<T, E> exceptionHandler) throws E {
        try {
            runnable.run();
        }
        catch (Exception e) {
            if (expectedExceptionType.isInstance(e)) {
                throw e;
            }
            if (e instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)e;
                throw re;
            }
            exceptionHandler.handle(e);
        }
    }

    public static Class<?>[] findImplementedInterfaces(Class<?> aClass) {
        Objects.requireNonNull(aClass, "Class to analyze cannot be null");
        LinkedList foundInterfaces = new LinkedList();
        for (Class<?> currentClass = aClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Class<?>[] interfaces = currentClass.getInterfaces();
            Collections.addAll(foundInterfaces, interfaces);
        }
        return foundInterfaces.toArray(new Class[0]);
    }

    private ClassUtils() {
    }
}

