/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import jakarta.inject.Inject;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.BackPressureReason;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.construct.FromFlowRejectedExecutionException;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.enricher.CpuLiteAsyncNonBlockingProcessingStrategyEnricher;
import org.mule.runtime.core.internal.processor.strategy.enricher.CpuLiteNonBlockingProcessingStrategyEnricher;
import org.mule.runtime.core.internal.processor.strategy.enricher.ProcessingTypeBasedReactiveProcessorEnricher;
import org.mule.runtime.core.internal.processor.strategy.enricher.ReactiveProcessorEnricher;
import org.mule.runtime.core.internal.processor.strategy.util.ProfilingUtils;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReactorStreamProcessingStrategy
extends AbstractStreamProcessingStrategyFactory.AbstractStreamProcessingStrategy
implements Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReactorStreamProcessingStrategy.class);
    private final Supplier<Scheduler> cpuLightSchedulerSupplier;
    private final int parallelism;
    private final AtomicInteger inFlightEvents = new AtomicInteger();
    private final BiConsumer<CoreEvent, Throwable> inFlightDecrementCallback = (e, t) -> {
        int decremented = this.inFlightEvents.decrementAndGet();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("decremented inFlightEvents={}", (Object)decremented);
        }
    };
    private Scheduler cpuLightScheduler;
    private ReactiveProcessorEnricher processorEnricher = null;
    @Inject
    InternalProfilingService profilingService;
    @Inject
    MuleContext muleContext;

    AbstractReactorStreamProcessingStrategy(int subscribers, Supplier<Scheduler> cpuLightSchedulerSupplier, int parallelism, int maxConcurrency, boolean maxConcurrencyEagerCheck) {
        super(subscribers, maxConcurrency, maxConcurrencyEagerCheck, () -> Thread.currentThread());
        this.cpuLightSchedulerSupplier = cpuLightSchedulerSupplier;
        this.parallelism = parallelism;
    }

    @Override
    public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
        return this.processorEnricher.enrich(processor);
    }

    protected ScheduledExecutorService getNonBlockingTaskScheduler() {
        return this.decorateScheduler((ScheduledExecutorService)this.getCpuLightScheduler());
    }

    @Override
    public void checkBackpressureAccepting(CoreEvent event) throws RejectedExecutionException {
        BackPressureReason reason = this.checkCapacity(event);
        if (reason != null) {
            throw new FromFlowRejectedExecutionException(reason);
        }
    }

    public void initialise() throws InitialisationException {
    }

    @Override
    public BackPressureReason checkBackpressureEmitting(CoreEvent event) {
        return this.checkCapacity(event);
    }

    protected BackPressureReason checkCapacity(CoreEvent event) {
        if (this.maxConcurrencyEagerCheck) {
            int incremented = this.inFlightEvents.incrementAndGet();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("incremented inFlightEvents={}", (Object)incremented);
            }
            if (incremented > this.maxConcurrency) {
                int decremented = this.inFlightEvents.decrementAndGet();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("decremented due to too large maxConcurrency={} inFlightEvents={}", (Object)this.maxConcurrency, (Object)decremented);
                }
                return BackPressureReason.MAX_CONCURRENCY_EXCEEDED;
            }
            ((BaseEventContext)event.getContext()).onBeforeResponse(this.inFlightDecrementCallback);
        }
        return null;
    }

    protected int getParallelism() {
        return this.parallelism;
    }

    public void start() throws MuleException {
        this.processorEnricher = this.getProcessingStrategyEnricher();
    }

    protected ProcessingTypeBasedReactiveProcessorEnricher getProcessingStrategyEnricher() {
        this.cpuLightScheduler = this.createCpuLightScheduler(this.cpuLightSchedulerSupplier);
        String artifactId = ProfilingUtils.getArtifactId(this.muleContext);
        String artifactType = ProfilingUtils.getArtifactType(this.muleContext);
        CpuLiteNonBlockingProcessingStrategyEnricher cpuLiteEnricher = new CpuLiteNonBlockingProcessingStrategyEnricher(() -> this.cpuLightScheduler, this.getProfilingService(), artifactId, artifactType);
        CpuLiteAsyncNonBlockingProcessingStrategyEnricher cpuLiteAsyncEnricher = new CpuLiteAsyncNonBlockingProcessingStrategyEnricher(() -> this.cpuLightScheduler, this::getNonBlockingTaskScheduler, this.getProfilingService(), artifactId, artifactType);
        return new ProcessingTypeBasedReactiveProcessorEnricher(cpuLiteEnricher).register(ReactiveProcessor.ProcessingType.CPU_LITE, cpuLiteEnricher).register(ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC, cpuLiteAsyncEnricher);
    }

    protected InternalProfilingService getProfilingService() {
        return this.profilingService;
    }

    public void stop() {
        this.inFlightEvents.getAndSet(0);
    }

    protected Scheduler createCpuLightScheduler(Supplier<Scheduler> cpuLightSchedulerSupplier) {
        return cpuLightSchedulerSupplier.get();
    }

    public void dispose() {
        this.stopSchedulersIfNeeded();
    }

    protected boolean stopSchedulersIfNeeded() {
        if (this.cpuLightScheduler != null) {
            this.cpuLightScheduler.stop();
            this.cpuLightScheduler = null;
        }
        return true;
    }

    protected Scheduler getCpuLightScheduler() {
        return this.cpuLightScheduler;
    }

    protected int getBufferQueueSize() {
        return AbstractStreamProcessingStrategyFactory.DEFAULT_BUFFER_SIZE;
    }
}

