/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lock;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.lock.LockProvider;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.internal.lock.InstanceLockGroup;
import org.mule.runtime.core.internal.lock.LockAdapter;
import org.mule.runtime.core.internal.lock.LockGroup;

public class MuleLockFactory
implements LockFactory,
Initialisable,
Disposable {
    private LockGroup lockGroup;
    private LockProvider lockProvider;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private MuleContext muleContext;

    public synchronized Lock createLock(String lockId) {
        return new LockAdapter(lockId, this.lockGroup, this.schedulerService);
    }

    public void dispose() {
        if (this.lockGroup != null) {
            this.lockGroup.dispose();
        }
    }

    public void initialise() throws InitialisationException {
        this.lockGroup = this.createLockGroup();
    }

    @Inject
    @Named(value="_muleLockProvider")
    public void setLockProvider(LockProvider lockProvider) {
        this.lockProvider = lockProvider;
    }

    private LockGroup createLockGroup() {
        if (this.muleContext == null) {
            return new InstanceLockGroup(this.lockProvider);
        }
        MuleConfiguration muleConfiguration = this.muleContext.getConfiguration();
        if (muleConfiguration == null) {
            return new InstanceLockGroup(this.lockProvider);
        }
        return new InstanceLockGroup(this.lockProvider, muleConfiguration.getShutdownTimeout());
    }
}

