/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.notification;

import jakarta.inject.Inject;
import java.util.Objects;
import java.util.function.Predicate;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;

public class DefaultNotificationListenerRegistry
implements NotificationListenerRegistry {
    private ServerNotificationManager notificationManager;

    public <N extends Notification> void registerListener(NotificationListener<N> listener) {
        Objects.requireNonNull(this.notificationManager, CoreMessages.serverNotificationManagerNotEnabled().getMessage());
        this.notificationManager.addListener(listener);
    }

    public <N extends Notification> void registerListener(NotificationListener<N> listener, Predicate<N> selector) {
        Objects.requireNonNull(this.notificationManager, CoreMessages.serverNotificationManagerNotEnabled().getMessage());
        Objects.requireNonNull(selector);
        this.notificationManager.addListenerSubscription(listener, selector);
    }

    public <N extends Notification> void unregisterListener(NotificationListener<N> listener) {
        if (this.notificationManager != null) {
            this.notificationManager.removeListener(listener);
        }
    }

    @Inject
    public void setNotificationManager(ServerNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }
}

