/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.metadata.internal;

import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.wsdl.parser.model.operation.OperationModel;
import org.mule.wsdl.parser.model.operation.Type;

public class SoapKitMetadataResolver {
    private static final String PARAMETER_INPUT_METADATA = "inputMetadata";
    public static final String BODY = "body";
    public static final String HEADERS = "headers";
    public static final String ATTACHMENTS = "attachments";
    public static final String PROTOCOL_HEADERS = "protocolHeaders";
    public static final String RESPONSE_PROTOCOL_HEADERS = "responseProtocolHeaders";
    private final OperationModel operationModel;

    public SoapKitMetadataResolver(OperationModel operationModel) {
        this.operationModel = operationModel;
    }

    public Optional<FunctionType> resolve() throws MetadataResolvingException {
        MuleEventMetadataType inputEvent = this.getEventMetadata(this.operationModel.getInputType(), this.getInputAttributes());
        MuleEventMetadataType outputEvent = this.getEventMetadata(this.operationModel.getOutputType(), this.getOutputAttributes());
        FunctionTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).functionType();
        FunctionType function = builder.addParameterOf(PARAMETER_INPUT_METADATA, (MetadataType)inputEvent).returnType((MetadataType)outputEvent).build();
        return Optional.of(function);
    }

    private MuleEventMetadataType getEventMetadata(Type operationType, MetadataType attributes) throws MetadataResolvingException {
        MessageMetadataType message = new MessageMetadataTypeBuilder().payload(this.getPayloadType(operationType)).attributes(attributes).build();
        return new MuleEventMetadataTypeBuilder().message(message).build();
    }

    private MetadataType getOutputAttributes() {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        builder.addField().key(RESPONSE_PROTOCOL_HEADERS).value((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType());
        return builder.build();
    }

    private MetadataType getInputAttributes() {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        builder.addField().key(PROTOCOL_HEADERS).value((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType());
        return builder.build();
    }

    private MetadataType getPayloadType(Type type) throws MetadataResolvingException {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        builder.addField().key(BODY).value(type.getBody());
        builder.addField().key(HEADERS).value(this.getHeadersInnerContent(type));
        builder.addField().key(ATTACHMENTS).value(type.getAttachments());
        return builder.build();
    }

    @NotNull
    private MetadataType getHeadersInnerContent(Type type) {
        Collection fields;
        MetadataType headers = type.getHeaders();
        if (headers instanceof ObjectType && (fields = ((ObjectType)headers).getFields()).size() > 0) {
            return ((ObjectFieldType)fields.iterator().next()).getValue();
        }
        return headers;
    }
}

