/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.metadata.internal;

import com.google.common.base.Strings;
import java.util.Optional;
import org.mule.metadata.api.model.FunctionType;
import org.mule.module.soapkit.metadata.api.Notifier;
import org.mule.module.soapkit.metadata.internal.SoapKitMetadataResolver;
import org.mule.module.soapkit.metadata.internal.model.ApplicationModelWrapper;
import org.mule.module.soapkit.metadata.internal.model.FlowCoordinate;
import org.mule.module.soapkit.metadata.internal.model.SoapKitConfig;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;
import org.mule.wsdl.parser.model.operation.OperationModel;

public class MetadataHandler {
    private ApplicationModelWrapper modelWrapper;
    private Notifier notifier;

    public MetadataHandler(ApplicationModelWrapper modelWrapper, Notifier notifier) {
        this.modelWrapper = modelWrapper;
        this.notifier = notifier;
    }

    public Optional<FunctionType> getMetadataForFlow(String flowName) {
        Optional<FlowCoordinate> coordinate = this.modelWrapper.getCoordinatesForFlow(flowName);
        if (!coordinate.isPresent()) {
            return Optional.empty();
        }
        Optional<SoapKitConfig> config = this.modelWrapper.getConfig(coordinate.get().getConfigName());
        if (!config.isPresent()) {
            return Optional.empty();
        }
        Optional<WsdlModel> wsdl = config.get().getWsdl();
        return wsdl.flatMap(wsdlModel -> this.generateMetadata((SoapKitConfig)config.get(), (WsdlModel)wsdlModel, (FlowCoordinate)coordinate.get()));
    }

    private Optional<FunctionType> generateMetadata(SoapKitConfig config, WsdlModel wsdlModel, FlowCoordinate coordinate) {
        if (Strings.isNullOrEmpty((String)config.getService())) {
            return Optional.empty();
        }
        ServiceModel service = wsdlModel.getService(config.getService());
        if (service == null) {
            return Optional.empty();
        }
        if (Strings.isNullOrEmpty((String)config.getPort())) {
            return Optional.empty();
        }
        PortModel port = service.getPort(config.getPort());
        if (port == null) {
            return Optional.empty();
        }
        try {
            OperationModel operation = port.getOperation(coordinate.getOperation());
            SoapKitMetadataResolver resolver = new SoapKitMetadataResolver(operation);
            return resolver.resolve();
        }
        catch (MetadataResolvingException e) {
            this.notifier.warn(String.format("Cannot resolve metadata for flow '%s'", coordinate.getFlowName()));
            return Optional.empty();
        }
    }
}

