/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.metadata.internal;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.mule.module.soapkit.metadata.internal.model.FlowCoordinate;
import org.mule.module.soapkit.metadata.internal.model.SoapKitConfig;

public class FlowCoordinateFactory {
    private static final String CONFIG_SEPARATOR = ":\\";
    private Map<String, SoapKitConfig> configMap;

    public FlowCoordinateFactory(Map<String, SoapKitConfig> configMap) {
        this.configMap = configMap;
    }

    public Optional<FlowCoordinate> createFromFlowName(String flowName) {
        String configName;
        ArrayList parts = Lists.newArrayList((Iterable)Splitter.on((String)CONFIG_SEPARATOR).omitEmptyStrings().split((CharSequence)flowName));
        if (parts.size() != 2) {
            return Optional.empty();
        }
        String operation = (String)parts.get(0);
        FlowCoordinate coordinate = FlowCoordinate.create(flowName, operation, configName = (String)parts.get(1));
        if (coordinate.getConfigName() != null && !this.configMap.containsKey(coordinate.getConfigName())) {
            return Optional.empty();
        }
        if (this.configMap.size() > 1 && coordinate.getConfigName() == null) {
            return Optional.empty();
        }
        return Optional.of(coordinate);
    }
}

