/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.api.trigger;

import com.mulesoft.connectivity.mule.api.Page;
import com.mulesoft.connectivity.mule.api.trigger.NextData;
import com.mulesoft.connectivity.mule.api.trigger.NextPoll;
import com.mulesoft.connectivity.mule.api.trigger.TriggerItem;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class TriggerPage
extends Page<TriggerItem> {
    private static final long serialVersionUID = 1L;
    private final NextPoll nextPoll;

    public TriggerPage(List<TriggerItem> items, Serializable nextPage, NextPoll nextPoll) {
        super(items, nextPage);
        this.nextPoll = nextPoll;
    }

    public NextPoll getNextPoll() {
        return this.nextPoll;
    }

    public NextData getNextData() {
        return new NextData(this.nextPoll, this.getNextPage().orElse(null));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append("{items=").append(this.getItems());
        this.getNextPage().ifPresent(nextPage -> sb.append(", nextPage=").append(nextPage));
        sb.append(", nextPoll= { greatestWatermark=").append(this.nextPoll.getGreatestWatermark()).append(", latestWatermark=").append(this.nextPoll.getLatestWatermark()).append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TriggerPage)) {
            return false;
        }
        TriggerPage result = (TriggerPage)o;
        return Objects.equals(this.getItems(), result.getItems()) && Objects.equals(this.getNextPage(), result.getNextPage()) && Objects.equals(this.nextPoll, result.getNextPoll());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getItems(), this.nextPoll, this.getNextPage());
    }

    public static TriggerPageFactory triggerPageFactory() {
        return new TriggerPageFactory();
    }

    public static class TriggerPageFactory
    extends Page.AbstractPageFactory<TriggerPage, TriggerItem> {
        @Override
        public TriggerPage fromNotPaginatedData(Object data, Function<Object, TriggerItem> buildItem) {
            throw new UnsupportedOperationException("Triggers always act as paginated operations");
        }

        @Override
        public TriggerPage fromPaginatedData(Object data, Function<Object, ? extends TriggerItem> buildItem) {
            Map pageMap = (Map)data;
            Map nextPoll = (Map)pageMap.get("nextPoll");
            Serializable greatestWatermarkEncoded = (Serializable)nextPoll.get("greatestWatermark");
            Serializable latestWatermarkEncoded = (Serializable)nextPoll.get("latestWatermark");
            Serializable nextPageEncoded = (Serializable)pageMap.get("nextPage");
            return new TriggerPage(TriggerPageFactory.mapList((List)pageMap.get("items"), buildItem), nextPageEncoded, new NextPoll(greatestWatermarkEncoded, latestWatermarkEncoded));
        }
    }
}

