/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.cache.internal.keygenerator;

import com.mulesoft.mule.runtime.cache.api.key.MuleEventKeyGenerator;
import jakarta.inject.Inject;
import java.security.MessageDigest;
import java.util.HexFormat;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.event.CoreEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHA256MuleEventKeyGenerator
implements MuleEventKeyGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SHA256MuleEventKeyGenerator.class);
    private TransformationService transformationService;

    @Override
    public String generateKey(CoreEvent event) {
        try {
            byte[] bytesOfMessage = (byte[])this.transformationService.transform(event.getMessage(), DataType.BYTE_ARRAY).getPayload().getValue();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String key = HexFormat.of().formatHex(md.digest(bytesOfMessage));
            logger.debug("Generated key for event: {} key: {}", (Object)event, (Object)key);
            return key;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Inject
    public void setTransformationService(TransformationService transformationService) {
        this.transformationService = transformationService;
    }
}

