/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lifecycle.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableRateExecutorService
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableRateExecutorService.class);
    private final ScheduledExecutorService executorService;
    private final int startingDelay;
    private final Map<String, ScheduledFuture<?>> scheduledTasks;

    public VariableRateExecutorService(ScheduledExecutorService executorService, int startingDelay) {
        this.executorService = executorService;
        this.startingDelay = startingDelay;
        this.scheduledTasks = new HashMap();
    }

    public void atRate(String key, int rate, Runnable runnable) {
        Optional.ofNullable(this.scheduledTasks.remove(key)).ifPresent(this::cancelTask);
        this.doSchedule(key, rate, runnable);
    }

    public void dispose() {
        this.scheduledTasks.forEach((key, future) -> this.cancelTask((ScheduledFuture<?>)future));
        this.executorService.shutdown();
    }

    private void cancelTask(ScheduledFuture<?> future) {
        try {
            if (!future.cancel(false)) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.debug("Unexpected error while stopping the scheduled task ", (Throwable)e);
        }
    }

    private void doSchedule(String key, int rate, Runnable runnable) {
        if (rate > 0) {
            this.scheduledTasks.put(key, this.executorService.scheduleAtFixedRate(runnable, Math.min(this.startingDelay, rate), rate, TimeUnit.SECONDS));
        }
    }
}

