/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal;

import com.google.common.base.Preconditions;
import com.hazelcast.core.IExecutorService;
import com.mulesoft.mule.runtime.module.cluster.internal.CurrentTimeInMillisCallable;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastExecutorService;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.mule.runtime.api.time.TimeSupplier;

public class HazelcastClientModeTimeSupplier
implements TimeSupplier {
    private IExecutorService executorService;

    public HazelcastClientModeTimeSupplier(HazelcastClusterManager hazelcastManager) {
        Preconditions.checkNotNull((Object)hazelcastManager, (Object)"Hazelcast manager cannot be null");
        this.executorService = new HazelcastExecutorService(hazelcastManager);
    }

    public void setExecutorService(IExecutorService executorService) {
        this.executorService = executorService;
    }

    public Long get() {
        Future remoteCallFuture = this.executorService.submit(this.getCurrentTimeInMillisCallable());
        try {
            return (Long)remoteCallFuture.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getAsLong() {
        Future remoteCallFuture = this.executorService.submit(this.getCurrentTimeInMillisCallable());
        try {
            return (Long)remoteCallFuture.get();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public Instant getAsInstant() {
        return Instant.ofEpochMilli(this.getAsLong());
    }

    private Callable getCurrentTimeInMillisCallable() {
        return new CurrentTimeInMillisCallable();
    }
}

