/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.twopc;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixRollbackException;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.internal.XAResourceManager;
import bitronix.tm.twopc.AbstractPhaseEngine;
import bitronix.tm.twopc.PhaseException;
import bitronix.tm.twopc.executor.Executor;
import bitronix.tm.twopc.executor.Job;
import bitronix.tm.utils.Decoder;
import jakarta.transaction.RollbackException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.transaction.xa.XAException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Preparer
extends AbstractPhaseEngine {
    private static final Logger log = LoggerFactory.getLogger(Preparer.class);
    private final List<XAResourceHolderState> preparedResources = Collections.synchronizedList(new ArrayList());

    public Preparer(Executor executor) {
        super(executor);
    }

    public List<XAResourceHolderState> prepare(BitronixTransaction transaction) throws RollbackException, BitronixSystemException {
        XAResourceManager resourceManager = transaction.getResourceManager();
        transaction.setStatus(7);
        this.preparedResources.clear();
        if (resourceManager.size() == 0) {
            if (TransactionManagerServices.getConfiguration().isWarnAboutZeroResourceTransaction()) {
                log.warn("executing transaction with 0 enlisted resource");
            } else if (log.isDebugEnabled()) {
                log.debug("0 resource enlisted, no prepare needed");
            }
            transaction.setStatus(2);
            return this.preparedResources;
        }
        if (resourceManager.size() == 1) {
            XAResourceHolderState resourceHolder = resourceManager.getAllResources().get(0);
            this.preparedResources.add(resourceHolder);
            if (log.isDebugEnabled()) {
                log.debug("1 resource enlisted, no prepare needed (1PC)");
            }
            transaction.setStatus(2);
            return this.preparedResources;
        }
        try {
            this.executePhase(resourceManager, false);
        }
        catch (PhaseException ex) {
            this.logFailedResources(ex);
            this.throwException("transaction failed during prepare of " + String.valueOf(transaction), ex);
        }
        transaction.setStatus(2);
        if (log.isDebugEnabled()) {
            log.debug("successfully prepared " + this.preparedResources.size() + " resource(s)");
        }
        return Collections.unmodifiableList(this.preparedResources);
    }

    private void throwException(String message, PhaseException phaseException) throws BitronixRollbackException {
        List<Exception> exceptions = phaseException.getExceptions();
        List<XAResourceHolderState> resources = phaseException.getResourceStates();
        ArrayList<XAResourceHolderState> heuristicResources = new ArrayList<XAResourceHolderState>();
        ArrayList<XAResourceHolderState> errorResources = new ArrayList<XAResourceHolderState>();
        for (int i = 0; i < exceptions.size(); ++i) {
            Exception ex = exceptions.get(i);
            XAResourceHolderState resourceHolder = resources.get(i);
            if (ex instanceof XAException) {
                XAException xaEx = (XAException)ex;
                if (xaEx.errorCode == -4) {
                    heuristicResources.add(resourceHolder);
                    continue;
                }
                errorResources.add(resourceHolder);
                continue;
            }
            errorResources.add(resourceHolder);
        }
        if (heuristicResources.size() > 0) {
            throw new BitronixRollbackException(message + ": resource(s) " + Decoder.collectResourcesNames(heuristicResources) + " unilaterally finished transaction branch before being asked to prepare", phaseException);
        }
        throw new BitronixRollbackException(message + ": resource(s) " + Decoder.collectResourcesNames(errorResources) + " threw unexpected exception", phaseException);
    }

    @Override
    protected Job createJob(XAResourceHolderState xaResourceHolderState) {
        return new PrepareJob(xaResourceHolderState);
    }

    @Override
    protected boolean isParticipating(XAResourceHolderState xaResourceHolderState) {
        return true;
    }

    private final class PrepareJob
    extends Job {
        public PrepareJob(XAResourceHolderState resourceHolder) {
            super(resourceHolder);
        }

        @Override
        public void execute() {
            try {
                int vote;
                XAResourceHolderState resourceHolder = this.getResource();
                if (log.isDebugEnabled()) {
                    log.debug("preparing resource " + String.valueOf(resourceHolder));
                }
                if ((vote = resourceHolder.getXAResource().prepare(resourceHolder.getXid())) != 3) {
                    Preparer.this.preparedResources.add(resourceHolder);
                }
                if (log.isDebugEnabled()) {
                    log.debug("prepared resource " + String.valueOf(resourceHolder) + " voted " + Decoder.decodePrepareVote(vote));
                }
            }
            catch (RuntimeException ex) {
                this.runtimeException = ex;
            }
            catch (XAException ex) {
                this.xaException = ex;
            }
        }

        public String toString() {
            return "a PrepareJob with " + String.valueOf(this.getResource());
        }
    }
}

