/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.lrc;

import bitronix.tm.resource.jdbc.BaseProxyHandlerClass;
import bitronix.tm.resource.jdbc.lrc.LrcConnectionHandle;
import bitronix.tm.resource.jdbc.lrc.LrcXAResource;
import bitronix.tm.utils.ClassLoaderUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LrcXAConnection
extends BaseProxyHandlerClass {
    private static final Logger log = LoggerFactory.getLogger(LrcXAConnection.class);
    private final Connection connection;
    private final LrcXAResource xaResource;
    private final List<ConnectionEventListener> connectionEventListeners = new CopyOnWriteArrayList<ConnectionEventListener>();

    public LrcXAConnection(Connection connection) {
        this.connection = connection;
        this.xaResource = new LrcXAResource(connection);
    }

    public XAResource getXAResource() throws SQLException {
        return this.xaResource;
    }

    public void close() throws SQLException {
        this.connection.close();
        this.fireCloseEvent();
    }

    public Connection getConnection() throws SQLException {
        LrcConnectionHandle lrcConnectionHandle = new LrcConnectionHandle(this.xaResource, this.connection);
        return (Connection)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)lrcConnectionHandle);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    private void fireCloseEvent() {
        if (log.isDebugEnabled()) {
            log.debug("notifying " + this.connectionEventListeners.size() + " connectionEventListeners(s) about closing of " + String.valueOf(this));
        }
        for (ConnectionEventListener connectionEventListener : this.connectionEventListeners) {
            XAConnection conn = (XAConnection)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{XAConnection.class}, (InvocationHandler)this);
            connectionEventListener.connectionClosed(new ConnectionEvent(conn));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LrcXAConnection)) {
            return false;
        }
        LrcXAConnection other = (LrcXAConnection)obj;
        return this.connection.equals(other.connection);
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public String toString() {
        return "a JDBC LrcXAConnection on " + String.valueOf(this.connection);
    }

    @Override
    public Object getProxiedDelegate() throws Exception {
        return this.connection;
    }
}

