/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.recovery.IncrementalRecoverer;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistrar {
    private static final Logger log = LoggerFactory.getLogger(ResourceRegistrar.class);
    private static ReadWriteLock resourcesReadWriteLock = new ReentrantReadWriteLock();
    private static Lock resourcesReadLock = resourcesReadWriteLock.readLock();
    private static Lock resourcesWriteLock = resourcesReadWriteLock.writeLock();
    private static final HashMap<String, XAResourceProducer> resources = new HashMap();

    public static XAResourceProducer get(String uniqueName) {
        resourcesReadLock.lock();
        try {
            XAResourceProducer xAResourceProducer = resources.get(uniqueName);
            return xAResourceProducer;
        }
        finally {
            resourcesReadLock.unlock();
        }
    }

    public static Set<String> getResourcesUniqueNames() {
        resourcesReadLock.lock();
        try {
            Set<String> set = Collections.unmodifiableSet(new HashSet<String>(resources.keySet()));
            return set;
        }
        finally {
            resourcesReadLock.unlock();
        }
    }

    public static void register(XAResourceProducer producer) throws RecoveryException {
        String uniqueName = producer.getUniqueName();
        if (uniqueName == null) {
            throw new IllegalArgumentException("invalid resource with null uniqueName");
        }
        resourcesWriteLock.lock();
        try {
            if (resources.containsKey(uniqueName)) {
                throw new IllegalArgumentException("resource with uniqueName '" + producer.getUniqueName() + "' has already been registered");
            }
            if (TransactionManagerServices.isTransactionManagerRunning()) {
                if (log.isDebugEnabled()) {
                    log.debug("transaction manager is running, recovering resource " + uniqueName);
                }
                IncrementalRecoverer.recover(producer);
            }
            resources.put(uniqueName, producer);
        }
        finally {
            resourcesWriteLock.unlock();
        }
    }

    public static void unregister(XAResourceProducer producer) {
        String uniqueName = producer.getUniqueName();
        if (uniqueName == null) {
            throw new IllegalArgumentException("invalid resource with null uniqueName");
        }
        resourcesWriteLock.lock();
        try {
            if (!resources.containsKey(uniqueName)) {
                if (log.isDebugEnabled()) {
                    log.debug("resource with uniqueName '" + producer.getUniqueName() + "' has not been registered");
                }
                return;
            }
            resources.remove(uniqueName);
        }
        finally {
            resourcesWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XAResourceHolder findXAResourceHolder(XAResource xaResource) {
        resourcesReadLock.lock();
        try {
            for (Map.Entry<String, XAResourceProducer> entry : resources.entrySet()) {
                XAResourceProducer producer = entry.getValue();
                XAResourceHolder resourceHolder = producer.findXAResourceHolder(xaResource);
                if (resourceHolder != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("XAResource " + String.valueOf(xaResource) + " belongs to " + String.valueOf(resourceHolder) + " that itself belongs to " + String.valueOf(producer));
                    }
                    XAResourceHolder xAResourceHolder = resourceHolder;
                    return xAResourceHolder;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("XAResource " + String.valueOf(xaResource) + " does not belong to any resource of " + String.valueOf(producer));
            }
            Iterator<Map.Entry<String, XAResourceProducer>> iterator = null;
            return iterator;
        }
        finally {
            resourcesReadLock.unlock();
        }
    }

    public static void clear() {
        resourcesWriteLock.lock();
        try {
            resources.clear();
        }
        finally {
            resourcesWriteLock.unlock();
        }
    }
}

