/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.gui;

import bitronix.tm.gui.TransactionTableModel;
import bitronix.tm.journal.TransactionLogRecord;
import bitronix.tm.utils.Decoder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TableModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingTransactionTableModel
extends TransactionTableModel {
    private static final Logger log = LoggerFactory.getLogger(PendingTransactionTableModel.class);
    private Map pendingTLogs = new HashMap();

    public PendingTransactionTableModel(File filename) {
        try {
            this.readFullTransactionLog(filename);
        }
        catch (Exception ex) {
            log.error("corrupted log file", (Throwable)ex);
        }
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public int getRowCount() {
        return this.tLogs.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TransactionLogRecord tlog = (TransactionLogRecord)this.tLogs.get(rowIndex);
        return switch (columnIndex) {
            case 0 -> Decoder.decodeStatus(tlog.getStatus());
            case 1 -> "" + tlog.getRecordLength();
            case 2 -> "" + tlog.getHeaderLength();
            case 3 -> "" + tlog.getTime();
            case 4 -> "" + tlog.getSequenceNumber();
            case 5 -> "" + tlog.getCrc32();
            case 6 -> "" + tlog.getUniqueNames().size();
            case 7 -> tlog.getGtrid().toString();
            default -> null;
        };
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public String getColumnName(int columnIndex) {
        return switch (columnIndex) {
            case 0 -> "Record Status";
            case 1 -> "Record length";
            case 2 -> "Header length";
            case 3 -> "Record time";
            case 4 -> "Record sequence number";
            case 5 -> "CRC";
            case 6 -> "Resources";
            case 7 -> "GTRID";
            default -> null;
        };
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    protected void readFullTransactionLog(File filename) throws IOException {
        super.readFullTransactionLog(filename);
        this.pendingTLogs.clear();
    }

    @Override
    public boolean acceptLog(TransactionLogRecord tlog) {
        if (tlog.getStatus() == 8) {
            this.pendingTLogs.put(tlog.getGtrid(), tlog);
            return true;
        }
        if (tlog.getStatus() == 3 || tlog.getStatus() == 4 && this.pendingTLogs.containsKey(tlog.getGtrid().toString())) {
            this.tLogs.remove(this.pendingTLogs.get(tlog.getGtrid()));
        }
        return false;
    }

    @Override
    public TransactionLogRecord getRow(int row) {
        return (TransactionLogRecord)this.tLogs.get(row);
    }
}

