/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.backoff.scheduler.runnable;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.backoff.state.Stable;
import com.mulesoft.anypoint.backoff.state.State;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;

public abstract class BackoffRunnable
implements Runnable {
    private State currentState;

    public BackoffRunnable(BackoffConfiguration configuration, BackoffBarrier backoffBarrier) {
        this.currentState = new Stable(configuration, backoffBarrier);
    }

    @Override
    public void run() {
        SessionMetadata metadata = this.execute();
        this.currentState = this.currentState.next(metadata);
    }

    public BackoffRunnable ifUnstable(Runnable closure) {
        this.currentState.ifUnstable(closure);
        return this;
    }

    public BackoffRunnable ifError(Runnable closure) {
        this.currentState.ifError(closure);
        return this;
    }

    public BackoffRunnable otherwise(Runnable closure) {
        this.currentState.otherwise(closure);
        return this;
    }

    public BackoffRunnable go() {
        this.currentState.log().go();
        return this;
    }

    public Period delay() {
        return this.currentState.delay();
    }

    protected abstract SessionMetadata execute();

    public String toString() {
        return "BackoffRunnable{hashcode=" + this.hashCode() + ", currentState=" + String.valueOf(this.currentState) + "}";
    }
}

