/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.boot.license.internal;

import com.mulesoft.mule.runtime.module.boot.license.interrupt.TestingModeInterrupter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.module.boot.api.MuleContainerLifecycleWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MuleLicenseInterrupter
extends TestingModeInterrupter {
    private static Logger logger = LoggerFactory.getLogger(MuleLicenseInterrupter.class);
    private static final String INVALID_LICENSE_MESSAGE = "Invalid license";
    private static final int INTERRUPTION_EXIT_CODE = -1;
    private static long interruptionDelay = TimeUnit.HOURS.toMillis(12L);
    private final MuleContainerLifecycleWrapper container;
    private ScheduledExecutorService scheduledThreadPool;
    private AtomicBoolean interruptionScheduled = new AtomicBoolean(false);

    public MuleLicenseInterrupter() {
        this.container = null;
    }

    public MuleLicenseInterrupter(MuleContainerLifecycleWrapper container) {
        this.container = container;
    }

    @Override
    public void interruptDeferred() {
        if (this.interruptionScheduled.compareAndSet(false, true)) {
            this.getExecutor().schedule(() -> {
                this.dispose();
                if (this.container != null) {
                    this.container.stop(-1);
                } else {
                    logger.error(INVALID_LICENSE_MESSAGE);
                    System.exit(-1);
                }
            }, interruptionDelay, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public boolean isInterruptionScheduled() {
        return this.interruptionScheduled.get();
    }

    private ScheduledExecutorService getExecutor() {
        if (this.scheduledThreadPool == null) {
            this.scheduledThreadPool = Executors.newScheduledThreadPool(1, runnable -> {
                Thread lmThread = new Thread(runnable, "[LicenseManager]");
                lmThread.setDaemon(true);
                return lmThread;
            });
        }
        return this.scheduledThreadPool;
    }

    @Override
    public void dispose() {
        if (this.scheduledThreadPool != null) {
            this.scheduledThreadPool.shutdownNow();
        }
    }

    public static void setInterruptionDelay(long interruptionDelay) {
        MuleLicenseInterrupter.interruptionDelay = interruptionDelay;
    }
}

