/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.boot.license.internal;

import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.LicenseKeyException;
import com.mulesoft.licm.LicenseManagementFactory;
import com.mulesoft.licm.LicenseManager;
import com.mulesoft.licm.impl.MuleLicenseKey;
import com.mulesoft.mule.runtime.module.boot.license.LicenseKey;
import com.mulesoft.mule.runtime.module.boot.license.LicenseProvider;
import com.mulesoft.mule.runtime.module.boot.license.MuleLicenseException;
import com.mulesoft.mule.runtime.module.boot.license.internal.DefaultLicenseKey;
import com.mulesoft.mule.runtime.module.boot.license.interrupt.TestingModeInterrupter;

public class DefaultLicenseProvider
implements LicenseProvider {
    private static final String UNEXPECTED_ERROR_ON_LICENSE_VALIDATION = "Unexpected error on license validation";

    @Override
    public LicenseKey getLicenseKey(String product) throws MuleLicenseException {
        EnterpriseLicenseKey elKey;
        block8: {
            ClassLoader originalTccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(LicenseManagementFactory.class.getClassLoader());
            try {
                elKey = this.getLicenseManager().validate(product);
            }
            catch (LicenseKeyException e) {
                if (TestingModeInterrupter.isTestingMode()) {
                    TestingModeInterrupter.getInterrupter().interruptDeferred();
                    elKey = new MuleLicenseKey();
                    elKey.setEvaluation(true);
                    break block8;
                }
                throw new MuleLicenseException(UNEXPECTED_ERROR_ON_LICENSE_VALIDATION, (Exception)((Object)e));
            }
            catch (Exception e) {
                throw new MuleLicenseException(UNEXPECTED_ERROR_ON_LICENSE_VALIDATION, e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalTccl);
            }
        }
        return new DefaultLicenseKey(elKey);
    }

    protected LicenseManager getLicenseManager() throws LicenseKeyException {
        return LicenseManagementFactory.getInstance().createLicenseManager("mule-ee");
    }
}

