/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import java.util.List;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.builder.ComponentParameterAstBuilder;
import org.mule.runtime.ast.internal.DefaultComponentGenerationInformation;
import org.mule.runtime.ast.internal.DefaultComponentParameterAst;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

public class DefaultComponentParameterAstBuilder
implements ComponentParameterAstBuilder {
    private ParameterModel paramModel;
    private DefaultComponentAstBuilder ownerComponent;
    private ParameterGroupModel parameterGroupModel;
    private ComponentGenerationInformation generationInformation;
    private ComponentMetadataAst metadata;
    private String rawValue;
    private DefaultComponentAstBuilder complexValue;
    private List<ComponentAstBuilder> complexListValue;

    public ComponentParameterAstBuilder withParamModel(ParameterModel paramModel, ParameterGroupModel parameterGroupModel) {
        this.paramModel = paramModel;
        this.parameterGroupModel = parameterGroupModel;
        return this;
    }

    public ComponentParameterAstBuilder withOwnerComponent(ComponentAstBuilder ownerComponent) {
        this.ownerComponent = (DefaultComponentAstBuilder)ownerComponent;
        return this;
    }

    @Override
    public ComponentParameterAstBuilder withSyntax(DslElementSyntax syntax) {
        if (this.generationInformation != null) {
            throw new IllegalStateException("'syntax' already set");
        }
        this.generationInformation = DefaultComponentGenerationInformation.builder().withSyntax(syntax).build();
        return this;
    }

    @Override
    public ComponentParameterAstBuilder withMetadata(ComponentMetadataAst metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public ComponentParameterAstBuilder withValue(String rawValue) {
        this.rawValue = rawValue;
        return this;
    }

    @Override
    public ComponentParameterAstBuilder withValue(ComponentAstBuilder complexValue) {
        this.complexValue = (DefaultComponentAstBuilder)complexValue;
        return this;
    }

    @Override
    public ComponentParameterAstBuilder withValue(List<ComponentAstBuilder> complexListValue) {
        this.complexListValue = complexListValue;
        return this;
    }

    @Override
    public ComponentParameterAst build() {
        if (this.complexValue != null) {
            return new DefaultComponentParameterAst(this.complexValue, this.paramModel, this.parameterGroupModel, this.metadata, this.generationInformation, this.ownerComponent.getPropertiesResolver(), this.ownerComponent.getParameterModelUtils());
        }
        if (this.complexListValue != null) {
            return new DefaultComponentParameterAst(this.complexListValue, this.paramModel, this.parameterGroupModel, this.metadata, this.generationInformation, this.ownerComponent.getPropertiesResolver(), this.ownerComponent.getParameterModelUtils());
        }
        return new DefaultComponentParameterAst(this.rawValue, this.paramModel, this.parameterGroupModel, this.metadata, this.generationInformation, this.ownerComponent.getPropertiesResolver(), this.ownerComponent.getParameterModelUtils());
    }

    public DefaultComponentAstBuilder getComplexValue() {
        return this.complexValue;
    }

    public boolean isSimpleValue() {
        return this.rawValue != null;
    }
}

