/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.tooling.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mulesoft.agent.domain.tooling.BundleDescriptor;
import com.mulesoft.agent.external.handlers.tooling.TestConnectionRequest;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.mule.runtime.api.app.declaration.serialization.ArtifactDeclarationJsonSerializer;

class TestConnectionRequestAdapter
extends TypeAdapter<TestConnectionRequest> {
    private static final String DEPENDENCIES = "dependencies";
    private static final String ARTIFACT_DECLARATION = "artifactDeclaration";
    private final Gson gson = new Gson();

    TestConnectionRequestAdapter() {
    }

    public void write(JsonWriter out, TestConnectionRequest request) throws IOException {
        out = out.beginObject();
        if (request != null) {
            out.name(DEPENDENCIES).jsonValue(this.gson.toJson(request.getDependencies()));
            out.name(ARTIFACT_DECLARATION).jsonValue(ArtifactDeclarationJsonSerializer.getDefault((boolean)false).serialize(request.getArtifactDeclaration()));
        }
        out.endObject();
    }

    public TestConnectionRequest read(JsonReader in) throws IOException {
        JsonElement parse = new JsonParser().parse(in);
        if (parse.isJsonObject()) {
            JsonElement artifact;
            JsonObject jsonObject = parse.getAsJsonObject();
            TestConnectionRequest request = new TestConnectionRequest();
            Type bundleList = new TypeToken<List<BundleDescriptor>>(){}.getType();
            JsonElement dependencies = jsonObject.get(DEPENDENCIES);
            if (dependencies != null && dependencies.isJsonArray()) {
                request.setDependencies((List)this.gson.fromJson(dependencies, bundleList));
            }
            if ((artifact = jsonObject.get(ARTIFACT_DECLARATION)) != null && artifact.isJsonObject()) {
                request.setArtifactDeclaration(ArtifactDeclarationJsonSerializer.getDefault((boolean)false).deserialize(artifact.toString()));
            }
            return request;
        }
        return null;
    }
}

