/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.logging;

import com.google.inject.Inject;
import com.mulesoft.agent.domain.logging.LogLevel;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.services.LoggingService;
import java.util.NoSuchElementException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Named(value="logging.request.handler")
@Path(value="logging")
@Singleton
public class LoggingRequestHandler
extends ConfigurableExternalHandler {
    @Inject
    protected LoggingService loggingService;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @GET
    @Path(value="domains/{domainName}/{scope}")
    @Produces(value={"application/json"})
    public Response getDomainLogLevel(@PathParam(value="domainName") String domainName, @PathParam(value="scope") String scope) {
        if (this.isEnabled()) {
            try {
                return Response.ok().entity((Object)this.loggingService.getDomainLoggingLevel(domainName, scope)).build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @POST
    @Path(value="domains/{domainName}/{scope}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setDomainLogLevel(@PathParam(value="domainName") String domainName, @PathParam(value="scope") String scope, LogLevel logLevel) {
        if (this.isEnabled()) {
            try {
                this.loggingService.setDomainLoggingLevel(domainName, scope, logLevel);
                return Response.ok().build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @GET
    @Path(value="applications/{appName}/{scope}")
    @Produces(value={"application/json"})
    public Response getApplicationLogLevel(@PathParam(value="appName") String appName, @PathParam(value="scope") String scope) {
        if (this.isEnabled()) {
            try {
                return Response.ok().entity((Object)this.loggingService.getApplicationLoggingLevel(appName, scope)).build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @POST
    @Path(value="applications/{appName}/{scope}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setApplicationLogLevel(@PathParam(value="appName") String appName, @PathParam(value="scope") String scope, LogLevel logLevel) {
        if (this.isEnabled()) {
            try {
                this.loggingService.setApplicationLoggingLevel(appName, scope, logLevel);
                return Response.ok().build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }
}

