/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.reboot.license;

import com.mulesoft.mule.runtime.module.reboot.license.LicenseException;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseKeyHandler;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.mule.runtime.module.boot.internal.BootstrapConfigurationException;
import org.mule.runtime.module.boot.internal.BootstrapConfigurer;
import org.slf4j.Logger;

public abstract class LicenseBootstrapConfigurer
implements BootstrapConfigurer {
    public static final String LICENSE_FILE_NAME = "muleLicenseKey.lic";
    private final Logger bootstrapLogger;

    protected LicenseBootstrapConfigurer(Logger bootstrapLogger) {
        this.bootstrapLogger = bootstrapLogger;
    }

    public boolean configure() throws BootstrapConfigurationException {
        try {
            return this.doConfigure();
        }
        catch (LicenseException e) {
            throw new BootstrapConfigurationException(1, e.getCause());
        }
        catch (Exception e) {
            throw new BootstrapConfigurationException(1, (Throwable)e);
        }
    }

    protected abstract boolean doConfigure() throws LicenseException;

    public Logger getBootstrapLogger() {
        return this.bootstrapLogger;
    }

    protected LicenseKeyHandler createLicenseKeyHandler() {
        return new LicenseKeyHandler();
    }

    protected void moveLicenseKeyFileToMuleBaseConf(File licenseLocation) {
        File file;
        URL licenseUrl = Thread.currentThread().getContextClassLoader().getResource(LICENSE_FILE_NAME);
        if (licenseUrl == null && (file = new File(LICENSE_FILE_NAME)).exists()) {
            File target = new File(licenseLocation, LICENSE_FILE_NAME);
            try {
                Files.move(file.toPath(), target.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                this.bootstrapLogger.debug("Couldn't move license file from: " + file.getAbsolutePath() + "to: " + target.getAbsolutePath());
            }
        }
    }

    protected File lookupMuleBaseConf() {
        File muleHome = null;
        String muleHomeVar = System.getProperty("mule.home");
        if (muleHomeVar != null && !muleHomeVar.trim().equals("") && !muleHomeVar.equals("%MULE_HOME%")) {
            try {
                muleHome = new File(muleHomeVar).getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Problem with mule.home!");
            }
        }
        if (muleHome == null || !muleHome.exists() || !muleHome.isDirectory()) {
            throw new IllegalArgumentException("Either MULE_HOME is not set or does not contain a valid directory.");
        }
        File muleBase = null;
        File muleBaseConf = null;
        String muleBaseVar = System.getProperty("mule.base");
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals("%MULE_BASE%")) {
            try {
                muleBase = new File(muleBaseVar).getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Problem with mule.base!");
            }
        }
        if (muleBase == null) {
            muleBase = muleHome;
        }
        muleBaseConf = new File(muleBase, "conf");
        return muleBaseConf;
    }
}

