/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.Preconditions;
import org.mule.tooling.client.api.feature.Feature;

public interface Command {
    public Object invokeMethod(String var1, String[] var2, String[] var3);

    default public boolean isFeatureEnabled(String methodName, String[] classes) {
        Class[] parameterTypes = Arrays.stream(classes).map(argClass -> {
            try {
                return this.getClass().getClassLoader().loadClass((String)argClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("Feature '%s' is not supported with calling argument of type '%s'", methodName, argClass));
            }
        }).collect(Collectors.toList()).toArray(new Class[0]);
        try {
            Method method = this.getClass().getMethod(methodName, parameterTypes);
            if (!method.getReturnType().isAssignableFrom(Feature.class)) {
                throw new IllegalArgumentException(String.format("Method '%s' is not a Feature", methodName));
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static RuntimeException methodNotFound(Class<? extends Command> clazz, String methodName) {
        return new IllegalArgumentException(String.format("Method '%s' not found on '%s'", methodName, clazz));
    }

    public static RuntimeException notMatchingMethod(Class<? extends Command> clazz, String methodName, String[] classes) {
        return new IllegalArgumentException(String.format("Method '%s' not found on '%s' for parameter types '%s'", methodName, clazz, Arrays.toString(classes)));
    }

    default public void validateInput(String[] arguments, String[] receivedClasses, Class<?> ... expectedClasses) {
        Preconditions.checkState((receivedClasses.length == expectedClasses.length ? 1 : 0) != 0, (String)"Wrong number of classes received");
        Preconditions.checkState((arguments.length == expectedClasses.length ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
        for (int i = 0; i < receivedClasses.length; ++i) {
            String receivedClass = receivedClasses[i];
            String expectedClass = expectedClasses[i].getName();
            Preconditions.checkState((boolean)receivedClass.equals(expectedClass), (String)String.format("Wrong type of arguments when invoking method created on %s, expected: %s, got: %s", this.getClass().getName(), expectedClass, receivedClass));
        }
    }
}

