/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.record;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.impl.operation.ReplicatedMapDataSerializerHook;
import java.io.IOException;
import java.util.Objects;

public class ReplicatedMapEntryViewHolder
implements IdentifiedDataSerializable {
    private Data key;
    private Data value;
    private long creationTime;
    private long hits;
    private long lastAccessTime;
    private long lastUpdateTime;
    private long ttlMillis;

    public ReplicatedMapEntryViewHolder() {
    }

    public ReplicatedMapEntryViewHolder(Data key, Data value, long creationTime, long hits, long lastAccessTime, long lastUpdateTime, long ttlMillis) {
        this.key = key;
        this.value = value;
        this.creationTime = creationTime;
        this.hits = hits;
        this.lastAccessTime = lastAccessTime;
        this.lastUpdateTime = lastUpdateTime;
        this.ttlMillis = ttlMillis;
    }

    public Data getKey() {
        return this.key;
    }

    public Data getValue() {
        return this.value;
    }

    public ReplicatedMapEntryViewHolder setKey(Data key) {
        Preconditions.checkNotNull(key);
        this.key = key;
        return this;
    }

    public ReplicatedMapEntryViewHolder setValue(Data value) {
        Preconditions.checkNotNull(value);
        this.value = value;
        return this;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public ReplicatedMapEntryViewHolder setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public long getHits() {
        return this.hits;
    }

    public ReplicatedMapEntryViewHolder setHits(long hits) {
        this.hits = hits;
        return this;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public ReplicatedMapEntryViewHolder setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        return this;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public ReplicatedMapEntryViewHolder setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    public long getTtlMillis() {
        return this.ttlMillis;
    }

    public ReplicatedMapEntryViewHolder setTtlMillis(long ttlMillis) {
        this.ttlMillis = ttlMillis;
        return this;
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 28;
    }

    public String toString() {
        return "ReplicatedMapEntryViewHolder{key=" + this.getKey() + ", value=" + this.getValue() + ", creationTime=" + this.creationTime + ", hits=" + this.hits + ", lastAccessTime=" + this.lastAccessTime + ", lastUpdateTime=" + this.lastUpdateTime + ", ttlMillis=" + this.ttlMillis + "}";
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        IOUtil.writeData(out, this.key);
        IOUtil.writeData(out, this.value);
        out.writeLong(this.creationTime);
        out.writeLong(this.hits);
        out.writeLong(this.lastAccessTime);
        out.writeLong(this.lastUpdateTime);
        out.writeLong(this.ttlMillis);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = IOUtil.readData(in);
        this.value = IOUtil.readData(in);
        this.creationTime = in.readLong();
        this.hits = in.readLong();
        this.lastAccessTime = in.readLong();
        this.lastUpdateTime = in.readLong();
        this.ttlMillis = in.readLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicatedMapEntryViewHolder that = (ReplicatedMapEntryViewHolder)o;
        return this.creationTime == that.creationTime && this.hits == that.hits && this.lastAccessTime == that.lastAccessTime && this.lastUpdateTime == that.lastUpdateTime && this.ttlMillis == that.ttlMillis && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.creationTime, this.hits, this.lastAccessTime, this.lastUpdateTime, this.ttlMillis);
    }
}

