/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.introspector.internal.extractor.nativelib.elf;

import com.mulesoft.runtime.introspector.internal.extractor.nativelib.Architecture;
import java.util.HashMap;
import java.util.Map;

public enum ELFArchitecture {
    NONE(0, "No specific instruction set", Architecture.UNKNOWN),
    AT_AND_T_WE_32100(1, "AT&T WE 32100", Architecture.AT_AND_T_WE_32100),
    SPARC(2, "SPARC", Architecture.SPARC),
    X86(3, "x86", Architecture.x86),
    MOTOROLA_68000(4, "Motorola 68000 (M68k)", Architecture.MOTOROLA_68000),
    MOTOROLA_88000(5, "Motorola 88000 (M88k)", Architecture.MOTOROLA_88000),
    INTEL_MCU(6, "Intel MCU", Architecture.INTEL_MCU),
    INTEL_80860(7, "Intel 80860", Architecture.INTEL_80860),
    MIPS(8, "MIPS", Architecture.MIPS),
    IBM_SYSTEM_370(9, "IBM System/370", Architecture.IBM_SYSTEM_370),
    MIPS_RS3000_LE(10, "MIPS RS3000 Little-endian", Architecture.MIPS_RS3000_LE),
    HP_PA_RISC(15, "Hewlett-Packard PA-RISC", Architecture.HP_PA_RISC),
    INTEL_80960(19, "Intel 80960", Architecture.INTEL_80960),
    POWERPC(20, "PowerPC", Architecture.POWERPC),
    POWERPC_64(21, "PowerPC (64-bit)", Architecture.ppc64),
    S390(22, "S390, including S390x", Architecture.s390x),
    IBM_SPU_SPC(23, "IBM SPU/SPC", Architecture.IBM_SPU_SPC),
    NEC_V800(36, "NEC V800", Architecture.NEC_V800),
    FUJITSU_FR20(37, "Fujitsu FR20", Architecture.FUJITSU_FR20),
    TRW_RH_32(38, "TRW RH-32", Architecture.TRW_RH_32),
    MOTOROLA_RCE(39, "Motorola RCE", Architecture.MOTOROLA_RCE),
    ARM_32(40, "Arm (up to Armv7/AArch32)", Architecture.arm),
    DIGITAL_ALPHA(41, "Digital Alpha", Architecture.DIGITAL_ALPHA),
    SUPERH(42, "SuperH", Architecture.SUPERH),
    SPARC_V9(43, "SPARC Version 9", Architecture.SPARC_V9),
    SIEMENS_TRICORE(44, "Siemens TriCore embedded processor", Architecture.SIEMENS_TRICORE),
    ARGONAUT_RISC_CORE(45, "Argonaut RISC Core", Architecture.ARGONAUT_RISC_CORE),
    HITACHI_H8_300(46, "Hitachi H8/300", Architecture.HITACHI_H8_300),
    HITACHI_H8_300H(47, "Hitachi H8/300H", Architecture.HITACHI_H8_300H),
    HITACHI_H8S(48, "Hitachi H8S", Architecture.HITACHI_H8S),
    HITACHI_H8_500(49, "Hitachi H8/500", Architecture.HITACHI_H8_500),
    IA_64(50, "IA-64", Architecture.IA_64),
    STANFORD_MIPS_X(51, "Stanford MIPS-X", Architecture.STANFORD_MIPS_X),
    MOTOROLA_COLDFIRE(52, "Motorola ColdFire", Architecture.MOTOROLA_COLDFIRE),
    MOTOROLA_M68HC12(53, "Motorola M68HC12", Architecture.MOTOROLA_M68HC12),
    FUJITSU_MMA(54, "Fujitsu MMA Multimedia Accelerator", Architecture.FUJITSU_MMA),
    SIEMENS_PCP(55, "Siemens PCP", Architecture.SIEMENS_PCP),
    SONY_NCPU(56, "Sony nCPU embedded RISC processor", Architecture.SONY_NCPU),
    DENSO_NDR1(57, "Denso NDR1 microprocessor", Architecture.DENSO_NDR1),
    MOTOROLA_STARCORE(58, "Motorola Star*Core processor", Architecture.MOTOROLA_STARCORE),
    TOYOTA_ME16(59, "Toyota ME16 processor", Architecture.TOYOTA_ME16),
    ST_ST100(60, "STMicroelectronics ST100 processor", Architecture.ST_ST100),
    ALC_TINYJ(61, "Advanced Logic Corp. TinyJ embedded processor family", Architecture.ALC_TINYJ),
    X86_64(62, "x86-64", Architecture.amd64),
    SONY_DSP(63, "Sony DSP Processor", Architecture.SONY_DSP),
    DEC_PDP_10(64, "Digital Equipment Corp. PDP-10", Architecture.DEC_PDP_10),
    DEC_PDP_11(65, "Digital Equipment Corp. PDP-11", Architecture.DEC_PDP_11),
    SIEMENS_FX66(66, "Siemens FX66 microcontroller", Architecture.SIEMENS_FX66),
    ST_ST9_PLUS(67, "STMicroelectronics ST9+ 8/16 bit microcontroller", Architecture.ST_ST9_PLUS),
    ST_ST7(68, "STMicroelectronics ST7 8-bit microcontroller", Architecture.ST_ST7),
    MOTOROLA_MC68HC16(69, "Motorola MC68HC16 Microcontroller", Architecture.MOTOROLA_MC68HC16),
    MOTOROLA_MC68HC11(70, "Motorola MC68HC11 Microcontroller", Architecture.MOTOROLA_MC68HC11),
    MOTOROLA_MC68HC08(71, "Motorola MC68HC08 Microcontroller", Architecture.MOTOROLA_MC68HC08),
    MOTOROLA_MC68HC05(72, "Motorola MC68HC05 Microcontroller", Architecture.MOTOROLA_MC68HC05),
    SGI_SVX(73, "Silicon Graphics SVx", Architecture.SGI_SVX),
    ST_ST19(74, "STMicroelectronics ST19 8-bit microcontroller", Architecture.ST_ST19),
    DIGITAL_VAX(75, "Digital VAX", Architecture.DIGITAL_VAX),
    AXIS_32BIT(76, "Axis Communications 32-bit embedded processor", Architecture.AXIS_32BIT),
    INFINEON_32BIT(77, "Infineon Technologies 32-bit embedded processor", Architecture.INFINEON_32BIT),
    ELEMENT14_64BIT_DSP(78, "Element 14 64-bit DSP Processor", Architecture.ELEMENT14_64BIT_DSP),
    LSI_16BIT_DSP(79, "LSI Logic 16-bit DSP Processor", Architecture.LSI_16BIT_DSP),
    TMS320C6000(140, "TMS320C6000 Family", Architecture.TMS320C6000),
    MCST_ELBRUS_E2K(175, "MCST Elbrus e2k", Architecture.MCST_ELBRUS_E2K),
    AARCH_64(183, "aarch64", Architecture.arm64),
    ZILOG_Z80(220, "Zilog Z80", Architecture.ZILOG_Z80),
    RISC_V(243, "RISC-V", Architecture.RISC_V),
    BERKELEY_PACKET_FILTER(247, "Berkeley Packet Filter", Architecture.BERKELEY_PACKET_FILTER),
    WDC_65C816(257, "WDC 65C816", Architecture.WDC_65C816),
    LOONGARCH(258, "LoongArch", Architecture.LOONGARCH);

    private static final Map<Integer, ELFArchitecture> valuesToArchMap;
    private final int machineValue;
    private final String archDesc;
    private final Architecture architecture;

    public static Architecture resolve(short machineValue) {
        ELFArchitecture architecture = valuesToArchMap.get(machineValue);
        return architecture != null ? architecture.getArchitecture() : NONE.getArchitecture();
    }

    private ELFArchitecture(int machineValue, String archDesc, Architecture architecture) {
        this.machineValue = machineValue;
        this.archDesc = archDesc;
        this.architecture = architecture;
    }

    public String getArchDesc() {
        return this.archDesc;
    }

    public Integer getMachineValue() {
        return this.machineValue;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    static {
        valuesToArchMap = new HashMap<Integer, ELFArchitecture>();
        for (ELFArchitecture arch : ELFArchitecture.values()) {
            valuesToArchMap.put(arch.getMachineValue(), arch);
        }
    }
}

