/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.introspector.internal.extractor.flow;

import com.mulesoft.runtime.introspector.model.Flow;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;

public class FlowsDataExtractor {
    public static final String FLOWS_KEY = "flows";
    private static final Pattern APIKIT_FLOWNAME_PATTERN = Pattern.compile("(\\w*):(\\\\[^:]*)(:[^:]*)?:([^\\/\\\\\\[\\\\\\]\\{\\}#]*)");
    private static final Pattern APIKIT_SOAP_FLOWNAME_PATTERN = Pattern.compile("(\\w*):\\\\([^\\/\\\\\\[\\\\\\]\\{\\}#]*)");

    public Map<String, Flow> extractFrom(ArtifactAst artifact) {
        LinkedHashMap<String, Flow> flowsMap = new LinkedHashMap<String, Flow>();
        artifact.topLevelComponentsStream().filter(comp -> comp.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.FLOW)).filter(this::isBillableFlow).forEach(flow -> flowsMap.put((String)flow.getComponentId().get(), this.extractFlowData((ComponentAst)flow)));
        return flowsMap;
    }

    public Flow extractFlowData(ComponentAst flow) {
        boolean trigger = false;
        boolean apiImplementation = false;
        String flowName = (String)flow.getComponentId().get();
        if (this.isFirstElementEventSource(flow)) {
            trigger = true;
        } else if (FlowsDataExtractor.isApiKitFlow(flowName)) {
            apiImplementation = true;
        }
        return new Flow(trigger, apiImplementation);
    }

    private boolean isBillableFlow(ComponentAst flow) {
        return this.isFirstElementEventSource(flow) || FlowsDataExtractor.isApiKitFlow((String)flow.getComponentId().get());
    }

    private boolean isFirstElementEventSource(ComponentAst flow) {
        return flow.directChildrenStream().findFirst().map(comp -> comp.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.SOURCE)).orElse(false);
    }

    static boolean isApiKitFlow(String flowName) {
        return APIKIT_FLOWNAME_PATTERN.matcher(flowName).matches() || APIKIT_SOAP_FLOWNAME_PATTERN.matcher(flowName).matches();
    }
}

