/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.introspector.internal.extractor;

import com.mulesoft.runtime.introspector.exception.IntrospectionException;
import com.mulesoft.runtime.introspector.internal.extractor.file.ArtifactPathWalker;
import com.mulesoft.runtime.introspector.internal.extractor.file.ArtifactPathWalkerConfigurer;
import com.mulesoft.runtime.introspector.internal.extractor.file.ArtifactPathWalkerVisitor;
import com.mulesoft.runtime.introspector.internal.extractor.nativelib.Architecture;
import com.mulesoft.runtime.introspector.internal.extractor.nativelib.NativeLibraryReader;
import com.mulesoft.runtime.introspector.internal.extractor.nativelib.elf.NativeLibraryELFReader;
import com.mulesoft.runtime.introspector.model.nativelib.NativeLibrary;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibrariesSupportDataExtractor
implements ArtifactPathWalkerConfigurer<SortedSet<NativeLibrary>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeLibrariesSupportDataExtractor.class);
    public static final String NATIVE_LIBRARIES = "nativeLibraries";
    public static final String OS_FAMILY_UNIX_LINUX = "Unix/Linux";
    private static final String OS_FAMILY_WINDOWS = "Windows";
    private static final String OS_FAMILY_MAC_OSX = "MacOSX";
    private static final String NL_SUFFIX_UNIX_LINUX = ".so";
    private static final String NL_SUFFIX_WINDOWS = ".dll";
    private static final String NL_SUFFIX_MAC_OSX = ".dylib";
    private final NativeLibraryReader reader = new NativeLibraryELFReader();

    public Map<String, NativeLibrary> extract(ArtifactPathWalker artifactPathWalker) throws IntrospectionException {
        SortedSet nativeLibsResult;
        HashMap<String, AtomicInteger> nameCollisionsCounter = new HashMap<String, AtomicInteger>();
        LinkedHashMap<String, NativeLibrary> extracted = new LinkedHashMap<String, NativeLibrary>();
        try {
            nativeLibsResult = (SortedSet)artifactPathWalker.getResultFor(this).get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IntrospectionException(e);
        }
        catch (ExecutionException e) {
            throw new IntrospectionException(e.getCause());
        }
        if (nativeLibsResult == null) {
            return null;
        }
        for (NativeLibrary nativeLibrary : nativeLibsResult) {
            if (extracted.containsKey(nativeLibrary.getLibraryName())) {
                int count = nameCollisionsCounter.computeIfAbsent(nativeLibrary.getLibraryName(), k -> new AtomicInteger()).incrementAndGet();
                extracted.put(nativeLibrary.getLibraryName() + " #" + count, nativeLibrary);
                continue;
            }
            extracted.put(nativeLibrary.getLibraryName(), nativeLibrary);
        }
        return extracted;
    }

    @Override
    public ArtifactPathWalkerVisitor<SortedSet<NativeLibrary>> getWalkerVisitor() {
        return new NativeLibrariesWalkerVisitor(this);
    }

    private List<NativeLibrary> introspect(String location, String libraryFileName, InputStreamSupplier<InputStream> content) {
        if (libraryFileName.endsWith(NL_SUFFIX_UNIX_LINUX)) {
            return Collections.singletonList(this.library(libraryFileName, OS_FAMILY_UNIX_LINUX, location, this.determineElfArchitecture(location, libraryFileName, content)));
        }
        if (libraryFileName.endsWith(NL_SUFFIX_WINDOWS)) {
            return Collections.singletonList(this.library(libraryFileName, OS_FAMILY_WINDOWS, location, Architecture.UNKNOWN));
        }
        if (libraryFileName.endsWith(NL_SUFFIX_MAC_OSX)) {
            return Collections.singletonList(this.library(libraryFileName, OS_FAMILY_MAC_OSX, location, Architecture.UNKNOWN));
        }
        if (libraryFileName.endsWith(".jar")) {
            return this.introspectJarContents(location, content);
        }
        return Collections.emptyList();
    }

    public List<NativeLibrary> introspectJarContents(String location, InputStreamSupplier<InputStream> content) {
        ArrayList<NativeLibrary> libs = new ArrayList<NativeLibrary>();
        HashMap<String, Set<Architecture>> unixNativeLibsArch = new HashMap<String, Set<Architecture>>();
        HashMap<String, Set<Architecture>> winNativeLibsArch = new HashMap<String, Set<Architecture>>();
        HashMap<String, Set<Architecture>> macNativeLibsArch = new HashMap<String, Set<Architecture>>();
        try (ZipInputStream zis = new ZipInputStream(content.get());){
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                if (entry.getName().endsWith(NL_SUFFIX_UNIX_LINUX)) {
                    this.registerLibraryArchitecture(entry, unixNativeLibsArch, this.determineElfArchitecture(location, entry.getName(), () -> new ProxyInputStream(zis){

                        public void close() throws IOException {
                        }
                    }));
                    continue;
                }
                if (entry.getName().endsWith(NL_SUFFIX_WINDOWS)) {
                    this.registerLibraryArchitecture(entry, winNativeLibsArch, Architecture.UNKNOWN);
                    continue;
                }
                if (!entry.getName().endsWith(NL_SUFFIX_MAC_OSX)) continue;
                this.registerLibraryArchitecture(entry, macNativeLibsArch, Architecture.UNKNOWN);
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to determine introspect jar '" + location + "' to search for native libs: " + e.toString());
        }
        libs.addAll(this.registeredLibraries(unixNativeLibsArch, OS_FAMILY_UNIX_LINUX, location));
        libs.addAll(this.registeredLibraries(winNativeLibsArch, OS_FAMILY_WINDOWS, location));
        libs.addAll(this.registeredLibraries(macNativeLibsArch, OS_FAMILY_MAC_OSX, location));
        return libs;
    }

    private NativeLibrary library(String libraryName, String osFamilyName, String location, Architecture architecture) {
        return new NativeLibrary(libraryName, location, osFamilyName, Collections.singletonList(architecture.toString()));
    }

    private void registerLibraryArchitecture(ZipEntry entry, Map<String, Set<Architecture>> nativeLibsArch, Architecture architecture) {
        String[] entryNameParts = entry.getName().split("/");
        String libraryName = entryNameParts[entryNameParts.length - 1];
        nativeLibsArch.computeIfAbsent(libraryName, key -> new TreeSet()).add(architecture);
    }

    private List<NativeLibrary> registeredLibraries(Map<String, Set<Architecture>> nativeLibsArch, String osFamilyName, String location) {
        return nativeLibsArch.entrySet().stream().map(e -> new NativeLibrary((String)e.getKey(), location, osFamilyName, ((Set)e.getValue()).stream().map(Enum::toString).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    private Architecture determineElfArchitecture(String location, String libraryName, InputStreamSupplier<InputStream> content) {
        Architecture architecture;
        try (InputStream inputStream = content.get();){
            architecture = this.reader.getArchitecture(inputStream, libraryName);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to determine architecture for native lib '" + location + "!" + libraryName + "': " + e.toString());
            architecture = Architecture.UNKNOWN;
        }
        return architecture;
    }

    @FunctionalInterface
    public static interface InputStreamSupplier<IS extends InputStream> {
        public IS get() throws IOException;
    }

    private static final class NativeLibrariesWalkerVisitor
    implements ArtifactPathWalkerVisitor<SortedSet<NativeLibrary>> {
        private final NativeLibrariesSupportDataExtractor extractor;
        private final SortedSet<NativeLibrary> nativeLibs = new TreeSet<NativeLibrary>((nl1, nl2) -> {
            if (!nl1.getLibraryName().equals(nl2.getLibraryName())) {
                return nl1.getLibraryName().compareTo(nl2.getLibraryName());
            }
            return nl1.getLocation().compareTo(nl2.getLocation());
        });

        public NativeLibrariesWalkerVisitor(NativeLibrariesSupportDataExtractor extractor) {
            this.extractor = extractor;
        }

        @Override
        public SortedSet<NativeLibrary> getResult() {
            return this.nativeLibs;
        }

        @Override
        public boolean isPathHandled(Path path) {
            return this.isHandled(path.toString());
        }

        @Override
        public boolean isZipEntryHandled(ZipEntry entry) {
            return this.isHandled(entry.getName());
        }

        private boolean isHandled(String libraryFileName) {
            return libraryFileName.endsWith(NativeLibrariesSupportDataExtractor.NL_SUFFIX_UNIX_LINUX) || libraryFileName.endsWith(NativeLibrariesSupportDataExtractor.NL_SUFFIX_WINDOWS) || libraryFileName.endsWith(NativeLibrariesSupportDataExtractor.NL_SUFFIX_MAC_OSX) || libraryFileName.endsWith(".jar");
        }

        @Override
        public void onHandledPath(String resourceName, Path path) {
            this.nativeLibs.addAll(this.extractor.introspect(resourceName, path.getFileName().toString(), () -> new FileInputStream(path.toFile())));
        }

        @Override
        public void onHandledZipEntry(String resourceName, ZipFile zipFile, ZipEntry entry) {
            String location = entry.getName();
            String[] locationParts = location.split("/");
            this.nativeLibs.addAll(this.extractor.introspect(location, locationParts[locationParts.length - 1], () -> zipFile.getInputStream(entry)));
        }
    }
}

