/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.location;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;

public class Location {
    public static final String SOURCE = "source";
    public static final String CONNECTION = "connection";
    public static final String PARAMETERS = "parameters";
    public static final String PROCESSORS = "processors";
    public static final String ERROR_HANDLER = "errorHandler";
    protected static final String PARTS_SEPARATOR = "/";
    private LinkedList<String> parts = new LinkedList();

    public Location() {
    }

    public Location(List<String> parts) {
        this.parts.addAll(parts);
    }

    public String toString() {
        return String.join((CharSequence)PARTS_SEPARATOR, this.parts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return this.parts.equals(location.parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    public String getGlobalName() {
        return this.parts.get(0);
    }

    public List<String> getParts() {
        return this.parts.subList(1, this.parts.size());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFromStringRepresentation(String location) {
        String[] parts = location.split(PARTS_SEPARATOR);
        Builder builder = Location.builder();
        builder = builder.globalName(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            builder = builder.addPart(parts[i]);
        }
        return builder;
    }

    public static class Builder {
        private Location location = new Location();
        private boolean globalNameAlreadySet = false;

        public Builder globalName(String globalName) {
            this.globalNameAlreadySet = true;
            this.verifyPartDoesNotContainsSlash(globalName);
            Builder Builder2 = this.builderCopy();
            Builder2.location.parts.add(0, globalName);
            return Builder2;
        }

        public Builder addPart(String part) {
            this.verifyPartDoesNotContainsSlash(part);
            this.verifyIndexPartAfterProcessor(part);
            Builder Builder2 = this.builderCopy();
            Builder2.location.parts.addLast(part);
            return Builder2;
        }

        public Builder addConnectionPart() {
            this.checkIsNotFirstPart(Location.CONNECTION);
            Builder Builder2 = this.builderCopy();
            Builder2.location.parts.add(Location.CONNECTION);
            return Builder2;
        }

        public Builder addSourcePart() {
            this.checkIsNotFirstPart(Location.SOURCE);
            Builder Builder2 = this.builderCopy();
            Builder2.location.parts.add(Location.SOURCE);
            return Builder2;
        }

        public Builder addProcessorsPart() {
            this.checkIsNotFirstPart(Location.PROCESSORS);
            Builder Builder2 = this.builderCopy();
            Builder2.location.parts.add(Location.PROCESSORS);
            return Builder2;
        }

        public Builder addErrorHandlerPart() {
            this.checkIsNotFirstPart(Location.ERROR_HANDLER);
            Builder Builder2 = this.builderCopy();
            Builder2.location.parts.add(Location.ERROR_HANDLER);
            return Builder2;
        }

        public Builder addParameterPart() {
            this.checkIsNotFirstPart(Location.PARAMETERS);
            Builder Builder2 = this.builderCopy();
            Builder2.location.parts.add(Location.PARAMETERS);
            return Builder2;
        }

        public Builder addIndexPart(int index) {
            Preconditions.checkState((!this.location.parts.isEmpty() ? 1 : 0) != 0, (String)"An index cannot be the first part");
            Builder Builder2 = this.builderCopy();
            Builder2.location.parts.addLast(String.valueOf(index));
            return Builder2;
        }

        public Builder parts(List<String> parts) {
            Builder Builder2 = this.builderCopy();
            Builder2.location.parts = new LinkedList<String>(parts);
            return Builder2;
        }

        public Location build() {
            Preconditions.checkState((boolean)this.globalNameAlreadySet, (String)"global component name must be set");
            return this.location;
        }

        private void checkIsNotFirstPart(String partName) {
            Preconditions.checkState((!this.location.parts.isEmpty() ? 1 : 0) != 0, (String)("[" + partName + "] cannot be the first part"));
        }

        private void verifyIndexPartAfterProcessor(String part) {
            if (((String)this.location.parts.getLast()).equals(Location.PROCESSORS)) {
                Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)part), (String)"Only an index part can follow a processors part");
            }
        }

        private Builder builderCopy() {
            Builder Builder2 = new Builder();
            Builder2.globalNameAlreadySet = this.globalNameAlreadySet;
            Builder2.location.parts.addAll(this.location.parts);
            return Builder2;
        }

        private void verifyPartDoesNotContainsSlash(String globalName) {
            Preconditions.checkArgument((!globalName.contains(Location.PARTS_SEPARATOR) ? 1 : 0) != 0, (String)"Slash cannot be part of the global name or part");
        }
    }
}

