/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.nested;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;

public class NestedRouteModel
implements NestableElementModel {
    private String name;
    private int minOccurs;
    private Integer maxOccurs;
    private String description;
    private DisplayModel displayModel;
    private List<ParameterGroupModel> parameterGroupModels;
    private List<? extends NestableElementModel> childComponents;

    public NestedRouteModel() {
    }

    public NestedRouteModel(String name, String description, DisplayModel displayModel, int minOccurs, Integer maxOccurs, List<ParameterGroupModel> parameterGroupModels, List<? extends NestableElementModel> childComponents) {
        this.name = name;
        this.description = description;
        this.parameterGroupModels = parameterGroupModels;
        this.displayModel = displayModel;
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.childComponents = childComponents == null ? ImmutableList.of() : ImmutableList.copyOf(childComponents);
    }

    public boolean isRequired() {
        return this.minOccurs > 0;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public Optional<Integer> getMaxOccurs() {
        return Optional.ofNullable(this.maxOccurs);
    }

    public List<? extends NestableElementModel> getNestedComponents() {
        return this.childComponents;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public DisplayModel getDisplayModel() {
        return this.displayModel;
    }

    public List<ParameterGroupModel> getParameterGroupModels() {
        return this.parameterGroupModels;
    }

    public List<? extends NestableElementModel> getChildComponents() {
        return this.childComponents;
    }
}

