/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.dataweave.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.tooling.client.api.dataweave.validation.DataWeaveValidationError;

public class DataWeaveValidationResponse {
    private final List<DataWeaveValidationError> errors;

    private DataWeaveValidationResponse(List<DataWeaveValidationError> errors) {
        this.errors = errors;
    }

    public List<DataWeaveValidationError> getErrors() {
        return this.errors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<DataWeaveValidationError> errors = Collections.emptyList();
        private Exception exception;

        private Builder() {
        }

        public DataWeaveValidationResponse build() {
            return new DataWeaveValidationResponse(this.computeErrors());
        }

        private List<DataWeaveValidationError> computeErrors() {
            return this.errors.isEmpty() && this.isError() ? Arrays.asList(DataWeaveValidationError.builder().withMessage(this.exception.getMessage()).build()) : this.errors;
        }

        private boolean isError() {
            return this.exception != null || !this.errors.isEmpty();
        }

        public Builder withException(Exception exception) {
            this.exception = exception;
            return this;
        }

        public Builder withErrors(List<DataWeaveValidationError> errors) {
            this.errors = errors;
            return this;
        }
    }
}

