/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.configuration.agent;

import static java.lang.String.format;
import static java.util.Optional.ofNullable;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;

import java.net.URL;
import java.util.Optional;

import javax.net.ssl.SSLContext;

/**
 * Immutable implementation for {@link AgentConfiguration}.
 *
 * @since 1.0
 */
public class ImmutableAgentConfiguration implements AgentConfiguration {

  private URL toolingApiUrl;
  private int defaultConnectionTimeout;
  private int defaultReadTimeout;
  private SSLContext sslContext;

  public ImmutableAgentConfiguration(URL toolingApiUrl, int defaultConnectionTimeout, int defaultReadTimeout,
                                     SSLContext sslContext) {
    this.toolingApiUrl = toolingApiUrl;
    this.defaultConnectionTimeout = defaultConnectionTimeout;
    this.defaultReadTimeout = defaultReadTimeout;
    this.sslContext = sslContext;
  }

  @Override
  public URL getToolingApiUrl() {
    return toolingApiUrl;
  }

  @Override
  public int getDefaultConnectTimeout() {
    return defaultConnectionTimeout;
  }

  @Override
  public int getDefaultReadTimeout() {
    return defaultReadTimeout;
  }

  @Override
  public Optional<SSLContext> getSSLContext() {
    return ofNullable(this.sslContext);
  }

  @Override
  public String toString() {
    return format("%s{toolingApiUrl=%s,defaultConnectionTimeout=%sms, defaultReadTimeout=%sms}",
                  this.getClass().getName(), toolingApiUrl, defaultConnectionTimeout, defaultReadTimeout);
  }

}
