/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model;

import static java.util.Arrays.asList;
import static java.util.Collections.unmodifiableList;

import java.util.List;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * A model which provides directives for parameters that points to a file or directory.
 */
public class PathModel {

  private PathModelType type;
  private List<String> fileExtensions;
  private boolean acceptsUrls;

  // Just needed in order to serialize this object
  private PathModel() {}

  public PathModel(PathModelType type, boolean acceptsUrls, String[] fileExtensions) {
    this.type = type;
    this.acceptsUrls = acceptsUrls;
    this.fileExtensions = unmodifiableList(asList(fileExtensions));
  }

  public List<String> getFileExtensions() {
    return this.fileExtensions;
  }

  public PathModelType getType() {
    return this.type;
  }

  public boolean acceptsUrls() {
    return this.acceptsUrls;
  }

  public boolean equals(Object obj) {
    return EqualsBuilder.reflectionEquals(obj, this, new String[0]);
  }

  public int hashCode() {
    return HashCodeBuilder.reflectionHashCode(this, new String[0]);
  }

}
